/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycmptest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycmptest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.entitycmptest.TestBeanHome;
import java.util.Arrays;
import java.util.Properties;

public class Client
extends EETest {
    private static final int NUMLOOPS = 5;
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static Properties props = null;
    private static TSNamingContext nctx = null;
    private TestBeanHome beanHome = null;
    private TestBean beanRef = null;
    private Integer pkey = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        props = p;
        try {
            this.logMsg("Obtain naming context");
            nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)nctx.lookup(testBean, TestBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        int errors = 0;
        byte[] b = new byte[]{0};
        try {
            this.pkey = new Integer(1);
            this.logMsg("Create entity EJB with Primary Key = " + this.pkey.toString());
            this.beanRef = this.beanHome.create(this.pkey, "coffee-1", 1.0f, b);
            this.beanRef.initLogging(props);
            this.logMsg("Find entity EJB with Primary Key = " + this.pkey.toString());
            TestBean beanRef = this.beanHome.findByPrimaryKey(this.pkey);
            this.logMsg("Initialize remote logging");
            beanRef.initLogging(props);
            this.logMsg("Calling entity EJB methods getPrice()/updatePrice()");
            float price = 1.0f;
            for (int i = 0; i < 5; ++i) {
                float currentPrice = beanRef.getPrice();
                beanRef.updatePrice(currentPrice + 1.0f);
                float updatePrice = beanRef.getPrice();
                this.logMsg("Entity EJB currentPrice = " + currentPrice + ", updatePrice = " + updatePrice);
                if (currentPrice != price && updatePrice != currentPrice + 1.0f) {
                    ++errors;
                    if (currentPrice != price) {
                        TestUtil.logErr((String)("currentPrice mismatch, expected" + price));
                    }
                    if (updatePrice != currentPrice + 1.0f) {
                        TestUtil.logErr((String)("updatePrice mismatch, expected" + (currentPrice + 1.0f)));
                    }
                }
                price = updatePrice;
            }
            if (errors > 0) {
                this.logErr("The number of errors were: " + errors);
                throw new EETest.Fault("test1 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws EETest.Fault {
        boolean testResult1 = false;
        boolean testResult2 = false;
        boolean testResult3 = false;
        byte[] b = new byte[]{31, 32, 33, 63, 64, 65};
        int bv = 5;
        try {
            this.pkey = new Integer(2);
            this.logMsg("Create entity EJB with Primary Key = " + this.pkey.toString());
            this.beanRef = this.beanHome.create(this.pkey, "coffee-2", 2.0f, b);
            this.beanRef.initLogging(props);
            TestUtil.logMsg((String)"test2a");
            byte[] a = this.beanRef.getB();
            a[0] = (byte)(a[0] + bv);
            b = this.beanRef.getB();
            if (Arrays.equals(a, b)) {
                TestUtil.logMsg((String)"ERROR: Unexpected result in array comparison in test2a. ");
                for (int i = 0; i < a.length; ++i) {
                    TestUtil.logMsg((String)("Array a in test2a equals: " + a[i]));
                }
                for (int j = 0; j < b.length; ++j) {
                    TestUtil.logMsg((String)("Array b in test2a equals: " + b[j]));
                }
                testResult1 = false;
            } else {
                TestUtil.logMsg((String)"Expected results received for test2a");
                testResult1 = true;
            }
            TestUtil.logMsg((String)"test2b");
            this.beanRef.setB(a);
            byte[] c = this.beanRef.getB();
            if (!Arrays.equals(a, c)) {
                TestUtil.logMsg((String)"ERROR: Unexpected result in array comparison in test2b. ");
                for (int k = 0; k < a.length; ++k) {
                    TestUtil.logMsg((String)("Array a in test2b equals: " + a[k]));
                }
                for (int l = 0; l < c.length; ++l) {
                    TestUtil.logMsg((String)("Array c in test2b equals: " + c[l]));
                }
                testResult2 = false;
            } else {
                TestUtil.logMsg((String)"Expected results received for test2b");
                testResult2 = true;
            }
            TestUtil.logMsg((String)"test2c");
            a[1] = (byte)(a[1] + bv);
            if (Arrays.equals(a, c)) {
                TestUtil.logMsg((String)"ERROR: Unexpected result in array comparison in test2c. ");
                for (int m = 0; m < a.length; ++m) {
                    TestUtil.logMsg((String)("Array a in test2c equals: " + a[m]));
                }
                for (int n = 0; n < c.length; ++n) {
                    TestUtil.logMsg((String)("Array c in test2c equals: " + c[n]));
                }
                testResult3 = false;
            } else {
                TestUtil.logMsg((String)"Expected results received for test2c");
                testResult3 = true;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception caught during test2", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.beanRef.remove();
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!(testResult1 && testResult2 && testResult3)) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

