/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.pm.selfXself;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.pm.selfXself.Department;
import com.sun.ts.tests.ejb.ee.pm.selfXself.DepartmentHome;
import com.sun.ts.tests.ejb.ee.pm.selfXself.Employee;
import com.sun.ts.tests.ejb.ee.pm.selfXself.EmployeeHome;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    public static final int EMPLOYEEREF = 1;
    public static final int DEPTREF = 2;
    public static final int NUMOFEMPLOYEES = 10;
    public static final int NUMOFDEPTS = 5;
    public static final String EmployeeBean = "java:comp/env/ejb/Employee";
    public static final String DeptBean = "java:comp/env/ejb/Department";
    public static EmployeeHome employeeHome = null;
    public static DepartmentHome deptHome = null;
    public static final Date emp0date = new Date(12345678L);
    public static final Date emp1date = new Date(23456781L);
    public static final Date emp2date = new Date(34567812L);
    public static final Date emp3date = new Date(45678123L);
    public static final Date emp4date = new Date(56781234L);
    public static final Date emp5date = new Date(67812345L);
    public static final Date emp6date = new Date(78123456L);
    public static final Date emp7date = new Date(81234567L);
    public static final Date emp8date = new Date(45348281L);
    public static final Date emp9date = new Date(23672932L);
    private static Employee[] employeeRef = new Employee[20];
    private static Department[] deptRef = new Department[20];
    public static Properties props = null;
    private static TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public static void setup(String[] args, Properties p) throws Exception {
        TestUtil.logTrace((String)"Setup");
        TestUtil.logMsg((String)"Obtain Naming Context");
        nctx = new TSNamingContext();
        props = p;
        TestUtil.logMsg((String)"Lookup EmployeeBean: java:comp/env/ejb/Employee");
        employeeHome = (EmployeeHome)nctx.lookup(EmployeeBean, EmployeeHome.class);
        TestUtil.logMsg((String)"Lookup DepartmentBean: java:comp/env/ejb/Department");
        deptHome = (DepartmentHome)nctx.lookup(DeptBean, DepartmentHome.class);
        try {
            TestUtil.logMsg((String)"Check if test data already exists in Persistent Storage");
            if (Client.SchemaAlreadyExists()) {
                return;
            }
            TestUtil.logMsg((String)"Begin creating test data in Persistent Storage");
            TestUtil.logMsg((String)"Create Test EJB Data");
            Client.createEJBs(p);
            TestUtil.logMsg((String)"Done creating data in Persistent Storage");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            Client.RemoveTestEJBs();
            throw new Exception("Exception occurred: " + e);
        }
    }

    public void selfRefTest1() throws EETest.Fault {
        boolean pass = true;
        Employee e = null;
        Employee expectedResult = null;
        try {
            TestUtil.logMsg((String)"Get employee whose manager's last name is ");
            expectedResult = employeeHome.findByPrimaryKey(new Integer(2));
            TestUtil.logMsg((String)"Find employee's manager");
            e = employeeHome.findEmployeeByQuery1("Green");
            TestUtil.logMsg((String)"Check that we received the correct employee");
            if (!expectedResult.isIdentical(e)) {
                TestUtil.logErr((String)"findCustomerByQuery1 did not return expected result");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)("Caught exception selfRefTest1: " + ex));
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("selfRefTest1 failed", ex);
        }
        if (!pass) {
            throw new EETest.Fault("selfRefTest1 failed");
        }
    }

    public void selfRefTest2() throws EETest.Fault {
        boolean pass = true;
        Employee e = null;
        Integer expectedResult = new Integer(5);
        try {
            TestUtil.logMsg((String)"Find Employee by First Name");
            e = employeeHome.findEmployeeByQuery2("Russo");
            TestUtil.logMsg((String)"Check that we received the correct employee by last name");
            if (!expectedResult.equals(e.getId())) {
                pass = false;
            } else {
                TestUtil.logMsg((String)"Successfully returned expected results");
            }
        }
        catch (Exception ex) {
            TestUtil.logErr((String)("Caught exception selfRefTest2: " + ex));
            TestUtil.printStackTrace((Throwable)ex);
            throw new EETest.Fault("selfRefTest2 failed", ex);
        }
        if (!pass) {
            throw new EETest.Fault("selfRefTest2 failed");
        }
    }

    public void selfRefTest3() throws EETest.Fault {
        boolean pass = true;
        Employee empRef = null;
        try {
            this.logMsg("Create Entity Bean");
            empRef = employeeHome.findByPrimaryKey(new Integer(4));
            if (empRef.test3()) {
                TestUtil.logMsg((String)"relationship fields are null - expected");
            } else {
                TestUtil.logErr((String)"relationship fields are nonnull - unexpected");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            TestUtil.logErr((String)("Exception caught removing bean ref" + e));
            throw new EETest.Fault("selfRefTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("selfRefTest3 failed");
        }
    }

    public void selfRefTest4() throws EETest.Fault {
        boolean pass = false;
        Employee empRef = null;
        Date test4date = new Date(34458281L);
        try {
            this.logMsg("Create Entity Bean");
            empRef = employeeHome.create(new Integer(99), "Tamara", "Jones", test4date, 10500.0f);
            empRef.initLogging(props);
            pass = empRef.test4();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("selfRefTest4 failed", e);
        }
        finally {
            try {
                if (empRef != null) {
                    empRef.remove();
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logErr((String)"Error caught removing bean:", (Throwable)e);
            }
            if (!pass) {
                throw new EETest.Fault("selfRefTest4 failed");
            }
        }
    }

    private static boolean SchemaAlreadyExists() throws Exception {
        boolean schemaExists = true;
        TestUtil.logTrace((String)"SchemaAlreadyExists");
        Collection empCol = employeeHome.findAllEmployees();
        Collection deptCol = deptHome.findAllDepartments();
        if (empCol.size() != 10 || deptCol.size() != 5) {
            TestUtil.logMsg((String)("Number of employees found = " + empCol.size()));
            TestUtil.logMsg((String)("Number of departments found = " + deptCol.size()));
            schemaExists = false;
        }
        if (schemaExists) {
            TestUtil.logMsg((String)"Test data already exists in Persistent Storage");
            return true;
        }
        TestUtil.logMsg((String)"Test Data does not exist in Persistent Storage");
        Client.RemoveTestEJBs();
        return false;
    }

    private static void RemoveTestEJBs() {
        TestUtil.logTrace((String)"RemoveTestEJBs");
        try {
            TestUtil.logTrace((String)"Removing Employee EJBs");
            Collection col = employeeHome.findAllEmployees();
            Iterator i = col.iterator();
            while (i.hasNext()) {
                Employee eref = (Employee)PortableRemoteObject.narrow(i.next(), Employee.class);
                try {
                    eref.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            TestUtil.logTrace((String)"Removing Department EJBs");
            col = deptHome.findAllDepartments();
            i = col.iterator();
            while (i.hasNext()) {
                Department dref = (Department)PortableRemoteObject.narrow(i.next(), Department.class);
                try {
                    dref.remove();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private static void createEJBs(Properties p) throws Exception {
        props = p;
        TestUtil.logTrace((String)"createEJBs");
        TestUtil.logMsg((String)"Create Employee EJB's [10 employees]");
        TestUtil.logMsg((String)"Create Employee 1");
        Client.employeeRef[0] = employeeHome.create(new Integer(1), "Alan", "Brown", emp0date, 95000.0f);
        employeeRef[0].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 2");
        Client.employeeRef[1] = employeeHome.create(new Integer(2), "Arthur", "Fiedler", emp1date, 45000.0f);
        employeeRef[1].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 3");
        Client.employeeRef[2] = employeeHome.create(new Integer(3), "Sheila", "Murrow", emp2date, 23000.0f);
        employeeRef[2].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 4");
        Client.employeeRef[3] = employeeHome.create(new Integer(4), "Robert", "Redford", emp3date, 100500.0f);
        employeeRef[3].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 5");
        Client.employeeRef[4] = employeeHome.create(new Integer(5), "Stephen", "Russo", emp4date, 35000.0f);
        employeeRef[4].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 6");
        Client.employeeRef[5] = employeeHome.create(new Integer(6), "Karen", "Barry", emp5date, 85898.0f);
        employeeRef[5].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 7");
        Client.employeeRef[6] = employeeHome.create(new Integer(7), "Jared", "Green", emp6date, 93568.0f);
        employeeRef[6].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 8");
        Client.employeeRef[7] = employeeHome.create(new Integer(8), "Irene", "Carras", emp7date, 24598.0f);
        employeeRef[7].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 9");
        Client.employeeRef[8] = employeeHome.create(new Integer(9), "William", "Leeson", emp8date, 75980.0f);
        employeeRef[8].initLogging(props);
        TestUtil.logMsg((String)"Create Employee 10");
        Client.employeeRef[9] = employeeHome.create(new Integer(10), "Hudson", "Phillips", emp9date, 65432.0f);
        employeeRef[9].initLogging(props);
        TestUtil.logMsg((String)"Create Department EJB's [5 departments]");
        Client.deptRef[0] = deptHome.create(new Integer(1), "engineering");
        deptRef[0].initLogging(props);
        Client.deptRef[1] = deptHome.create(new Integer(2), "marketing");
        deptRef[1].initLogging(props);
        Client.deptRef[2] = deptHome.create(new Integer(3), "sales");
        deptRef[2].initLogging(props);
        Client.deptRef[3] = deptHome.create(new Integer(4), "services");
        deptRef[3].initLogging(props);
        Client.deptRef[4] = deptHome.create(new Integer(5), "support");
        deptRef[4].initLogging(props);
        TestUtil.logMsg((String)"Setting additional relationships for employeeRef[0]");
        employeeRef[0].addDepartment(deptRef[0]);
        employeeRef[0].addManager(employeeRef[5]);
        TestUtil.logMsg((String)"Setting additional relationships for employeeRef[1]");
        employeeRef[1].addDepartment(deptRef[1]);
        employeeRef[1].addManager(employeeRef[6]);
        TestUtil.logMsg((String)"Setting additional relationships for employeeRef[2]");
        employeeRef[2].addDepartment(deptRef[2]);
        employeeRef[2].addManager(employeeRef[7]);
        TestUtil.logMsg((String)"Setting additional relationships for employeeRef[3]");
        employeeRef[3].addDepartment(deptRef[3]);
        employeeRef[3].addManager(employeeRef[8]);
        TestUtil.logMsg((String)"Setting additional relationships for employeeRef[4]");
        employeeRef[4].addDepartment(deptRef[4]);
        employeeRef[4].addManager(employeeRef[9]);
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup Entity Data");
        Client.RemoveTestEJBs();
        TestUtil.logMsg((String)"cleanup ok");
    }
}

