/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest2.Hello;
import com.sun.ts.tests.webservices12.ejb.annotations.WSEjbWebServiceRefTest2.HelloService;
import jakarta.xml.ws.WebServiceRef;
import java.util.Properties;
import javax.naming.InitialContext;

public class Client
extends EETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private Hello port;
    @WebServiceRef(name="service/wsejbwebservicereftest2")
    static HelloService service;

    private void getPort() throws Exception {
        TestUtil.logMsg((String)"Get wsejbwebservicereftest2 Service via @WebServiceRef annotation");
        TestUtil.logMsg((String)"Uses name attribute @WebServiceRef(name=\"service/wsejbwebservicereftest2\")");
        TestUtil.logMsg((String)("service=" + (Object)((Object)service)));
        TestUtil.logMsg((String)"Get port from service");
        this.port = service.getHello();
        TestUtil.logMsg((String)("port=" + this.port));
        TestUtil.logMsg((String)"Port obtained");
        JAXWS_Util.dumpTargetEndpointAddress(this.port);
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            if (pass) {
                this.getPort();
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void printSeperationLine() {
        TestUtil.logMsg((String)"---------------------------");
    }

    public void WSEjbWebServiceRefTest2CallHello() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest2CallHello");
        try {
            String txt = this.port.hello("Hi there");
            if (!txt.equals("Hi there to you too!")) {
                throw new RuntimeException("Msg returned from hello() incorrect");
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest2CallHello passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest2CallHello failed");
        }
    }

    public void WSEjbWebServiceRefTest2CallBye() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest2CallBye");
        try {
            String txt = this.port.bye("Bye-bye");
            if (!txt.equals("Bye-bye and take care")) {
                throw new RuntimeException("Msg returned from bye() incorrect");
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest2CallBye passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest2CallBye failed");
        }
    }

    public void WSEjbWebServiceRefTest2VerifyTargetEndpointAddress() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest2VerifyTargetEndpointAddress");
        try {
            String endpointaddr = JAXWS_Util.getTargetEndpointAddress(this.port);
            TestUtil.logMsg((String)"Verify that the target endpoint address ends with [WSEjbWebServiceRefTest2/ejb]");
            if (!endpointaddr.endsWith("WSEjbWebServiceRefTest2/ejb")) {
                throw new RuntimeException("Target Endpoint Address is incorrect: " + endpointaddr);
            }
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest2VerifyTargetEndpointAddress passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest2VerifyTargetEndpointAddress failed");
        }
    }

    public void WSEjbWebServiceRefTest2VerifyJNDILookupOfService() throws EETest.Fault {
        TestUtil.logMsg((String)"WSEjbWebServiceRefTest2VerifyJNDILookupOfService");
        try {
            TestUtil.logMsg((String)"Test JNDI lookup for wsejbwebservicereftest2 Service");
            InitialContext ctx = new InitialContext();
            HelloService service = (HelloService)((Object)ctx.lookup("java:comp/env/service/wsejbwebservicereftest2"));
            TestUtil.logMsg((String)("service=" + (Object)((Object)service)));
            TestUtil.logMsg((String)"WSEjbWebServiceRefTest2VerifyJNDILookupOfService passed");
        }
        catch (Throwable t) {
            TestUtil.printStackTrace((Throwable)t);
            throw new EETest.Fault("WSEjbWebServiceRefTest2VerifyJNDILookupOfService failed");
        }
    }
}

