/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesQ3;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestQ3
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;

    public MsgBeanMsgTestQ3() {
        TestUtil.logTrace((String)"@MsgBeanMsgTest3()!");
    }

    public void ejbCreate() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ3  - @MsgBeanMsgTest3-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                TestUtil.logTrace((String)"qFactory error");
            }
            TestUtil.logTrace((String)"got a qFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                TestUtil.logTrace((String)"queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
            if (this.queue == null) {
                TestUtil.logTrace((String)"queue error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps(msg, this.p);
        TestUtil.logTrace((String)("from jms.ee.mdb.mdb_msgTypesQ3 @onMessage!" + msg));
        try {
            TestUtil.logTrace((String)("onMessage will run TestCase: " + msg.getStringProperty("TestCase")));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                TestUtil.logTrace((String)"connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueTextTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueTextTestCreate - create the message");
                this.msgClearBodyQueueTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueTextTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueTextTest - read and verify the message");
                this.msgClearBodyQueueTextTest((TextMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueObjectTestCreate - create the message");
                this.msgClearBodyQueueObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueObjectTest - read and verify the message");
                this.msgClearBodyQueueObjectTest((ObjectMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueMapTestCreate - create the message");
                this.msgClearBodyQueueMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueMapTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueMapTest - read and verify the message");
                this.msgClearBodyQueueMapTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueBytesTestCreate - create the message");
                this.msgClearBodyQueueBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueBytesTest - read and verify the message");
                this.msgClearBodyQueueBytesTest((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueStreamTestCreate - create the message");
                this.msgClearBodyQueueStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgClearBodyQueueStreamTest - read and verify the message");
                this.msgClearBodyQueueStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgResetQueueTest")) {
                TestUtil.logTrace((String)"@onMessage - running msgResetQueueTest - read and verify the message");
                this.msgResetQueueTest();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueStreamTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidQueueStreamTestCreate - read and verify the message");
                this.readNullCharNotValidQueueStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueStreamTest")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidQueueStreamTest - read and verify the message");
                this.readNullCharNotValidQueueStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueMapTestCreate")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidQueueMapTestCreate - read and verify the message");
                this.readNullCharNotValidQueueMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidQueueMapTest")) {
                TestUtil.logTrace((String)"@onMessage - running readNullCharNotValidQueueMapTest - read and verify the message");
                this.readNullCharNotValidQueueMapTest((MapMessage)msg);
            } else {
                TestUtil.logTrace((String)"@onMessage - invalid message type found in StringProperty");
                TestUtil.logTrace((String)("Do not have a method for this testcase: " + msg.getStringProperty("TestCase")));
            }
            TestUtil.logTrace((String)"@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgClearBodyQueueTextTestCreate() {
        try {
            TextMessage messageSent = null;
            messageSent = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("TestCase", "msgClearBodyQueueTextTest");
            TestUtil.logTrace((String)"sending a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueObjectTestCreate() {
        try {
            ObjectMessage messageSentObjectMsg = null;
            TestUtil.logTrace((String)"Send ObjectMessage to Queue.");
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, this.p);
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("TestCase", "msgClearBodyQueueObjectTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueMapTestCreate() {
        try {
            MapMessage messageSentMapMessage = null;
            TestUtil.logTrace((String)"Send MapMessage to Queue.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, this.p);
            messageSentMapMessage.setStringProperty("TestCase", "msgClearBodyQueueMapTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueBytesTestCreate() {
        byte bValue = 127;
        try {
            BytesMessage messageSentBytesMessage = null;
            TestUtil.logTrace((String)"Send BytesMessage to Queue.");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, this.p);
            messageSentBytesMessage.setStringProperty("TestCase", "msgClearBodyQueueBytesTest");
            messageSentBytesMessage.writeByte(bValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyQueueStreamTestCreate() {
        try {
            StreamMessage messageSentStreamMessage = null;
            TestUtil.logTrace((String)"sending a Stream message");
            messageSentStreamMessage = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, this.p);
            messageSentStreamMessage.setStringProperty("TestCase", "msgClearBodyQueueStreamTest");
            messageSentStreamMessage.writeString("Testing...");
            TestUtil.logTrace((String)"Sending message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueTextTest(TextMessage messageReceived) {
        String testCase = "msgClearBodyQueueTextTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test TextMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceived.getText()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceived.clearBody();
            if (messageReceived.getText() == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TestCase").equals("msgClearBodyQueueTextTest")) {
                TestUtil.logTrace((String)"Pass: Text properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Text properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write and read 2nd contents");
            messageReceived.setText("new data");
            if (messageReceived.getText().equals("new data")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueObjectTest(ObjectMessage messageReceivedObjectMsg) {
        String testCase = "msgClearBodyQueueObjectTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Testing Object message");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedObjectMsg.getObject()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedObjectMsg.clearBody();
            if (messageReceivedObjectMsg.getObject() == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedObjectMsg.getStringProperty("TestCase").equals("msgClearBodyQueueObjectTest")) {
                TestUtil.logTrace((String)"Pass: Object properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Object properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
            TestUtil.logTrace((String)"read 2nd contents");
            if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail: ");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgClearBodyQueueMapTest(MapMessage messageReceivedMapMessage) {
        String testCase = "msgClearBodyQueueMapTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test for MapMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedMapMessage.getString("aString")));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedMapMessage.clearBody();
            if (messageReceivedMapMessage.getString("aString") == null) {
                TestUtil.logTrace((String)"Empty body after clearBody as expected: null");
            } else {
                TestUtil.logTrace((String)"Fail: message body was not empty");
                TestUtil.logTrace((String)("Contains: " + messageReceivedMapMessage.getString("aString")));
                pass = false;
            }
            if (messageReceivedMapMessage.getStringProperty("TestCase").equals("msgClearBodyQueueMapTest")) {
                TestUtil.logTrace((String)"Pass: Map properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Map properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
            TestUtil.logTrace((String)"read 2nd contents");
            if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                TestUtil.logTrace((String)"PASS:");
            } else {
                TestUtil.logTrace((String)"FAIL:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueBytesTest(BytesMessage messageReceivedBytesMessage) {
        String testCase = "msgClearBodyQueueBytesTest";
        boolean pass = true;
        byte bValue2 = 22;
        try {
            TestUtil.logTrace((String)"Test BytesMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedBytesMessage.readByte()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedBytesMessage.clearBody();
            TestUtil.logTrace((String)"Bytes message body should now be empty and in writeonly mode");
            try {
                byte b = messageReceivedBytesMessage.readByte();
                TestUtil.logTrace((String)"Fail: MessageNotReadableException not thrown as expected");
                pass = false;
            }
            catch (MessageNotReadableException e) {
                TestUtil.logTrace((String)"Pass: MessageNotReadableException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            if (messageReceivedBytesMessage.getStringProperty("TestCase").equals("msgClearBodyQueueBytesTest")) {
                TestUtil.logTrace((String)"Pass: Bytes msg properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Bytes msg properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedBytesMessage.writeByte(bValue2);
            TestUtil.logTrace((String)"read 2nd contents");
            messageReceivedBytesMessage.reset();
            if (messageReceivedBytesMessage.readByte() == bValue2) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyQueueStreamTest(StreamMessage messageReceivedStreamMessage) {
        String testCase = "msgClearBodyQueueStreamTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Test StreamMessage ");
            TestUtil.logTrace((String)"read 1st contents");
            TestUtil.logTrace((String)("  " + messageReceivedStreamMessage.readString()));
            TestUtil.logTrace((String)"Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedStreamMessage.clearBody();
            TestUtil.logTrace((String)"Stream message body should now be empty and in writeonly mode");
            try {
                String s = messageReceivedStreamMessage.readString();
                TestUtil.logTrace((String)"Fail: MessageNotReadableException should have been thrown");
                pass = false;
            }
            catch (MessageNotReadableException e) {
                TestUtil.logTrace((String)"Pass: MessageNotReadableException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            if (messageReceivedStreamMessage.getStringProperty("TestCase").equals("msgClearBodyQueueStreamTest")) {
                TestUtil.logTrace((String)"Pass: Stream msg properties read ok after clearBody called");
            } else {
                TestUtil.logTrace((String)"Fail: Stream msg properties cleared after clearBody called");
                pass = false;
            }
            TestUtil.logTrace((String)"write 2nd contents");
            messageReceivedStreamMessage.writeString("new data");
            TestUtil.logTrace((String)"read 2nd contents");
            messageReceivedStreamMessage.reset();
            if (messageReceivedStreamMessage.readString().equals("new data")) {
                TestUtil.logTrace((String)"Pass:");
            } else {
                TestUtil.logTrace((String)"Fail:");
            }
        }
        catch (Exception e) {
            TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgResetQueueTest() {
        boolean pass = true;
        int nInt = 1000;
        String testCase = "msgResetQueueTest";
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            try {
                TestUtil.logTrace((String)"creating a Stream message");
                messageSentStreamMessage = this.qSession.createStreamMessage();
                JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, this.p);
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest1");
                messageSentStreamMessage.writeString("Testing...");
                TestUtil.logTrace((String)"reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                TestUtil.logTrace((String)"Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                TestUtil.logTrace((String)"Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
            try {
                TestUtil.logTrace((String)"creating a Byte message");
                messageSentBytesMessage = this.qSession.createBytesMessage();
                JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, this.p);
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest2");
                messageSentBytesMessage.writeInt(nInt);
                TestUtil.logTrace((String)"reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                TestUtil.logTrace((String)"Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                TestUtil.logTrace((String)"Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void readNullCharNotValidQueueMapTestCreate() {
        try {
            MapMessage mapSent = null;
            boolean pass = true;
            mapSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)mapSent, this.p);
            mapSent.setStringProperty("TestCase", "readNullCharNotValidQueueMapTest");
            TestUtil.logTrace((String)"Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            TestUtil.logTrace((String)" Send the message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)mapSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void readNullCharNotValidQueueStreamTestCreate() {
        try {
            StreamMessage messageSent = null;
            boolean pass = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidQueueStreamTest");
            TestUtil.logTrace((String)"Write a null string to the map message object with streamMessage.setString");
            messageSent.writeString(null);
            TestUtil.logTrace((String)" Send the message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidQueueMapTest(MapMessage mapReceived) {
        String testCase = "readNullCharNotValidQueueMapTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Use readChar to read a null  ");
            try {
                char c = mapReceived.getChar("WriteANull");
                TestUtil.logTrace((String)"Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                TestUtil.logTrace((String)"Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidQueueStreamTest(StreamMessage messageReceived) {
        String testCase = "readNullCharNotValidQueueStreamTest";
        boolean pass = true;
        try {
            TestUtil.logTrace((String)"Use readChar to read a null  ");
            try {
                char c = messageReceived.readChar();
                TestUtil.logTrace((String)"Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                TestUtil.logTrace((String)"Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                TestUtil.logTrace((String)("Error: Unexpected exception " + e.getClass().getName() + " was thrown"));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            TestUtil.logTrace((String)"Sending response message");
            TestUtil.logTrace((String)("==================================Test Results from: " + testCase));
            TestUtil.logTrace((String)("==================================Status: " + results));
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            TestUtil.logTrace((String)("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown"));
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            TestUtil.logTrace((String)("Error: " + ee.getClass().getName() + " was thrown"));
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ3  In MsgBeanMsgTest3::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"jms.ee.mdb.mdb_msgTypesQ3  In MsgBeanMsgTest3::remove()!!");
    }
}

