/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.expire;

import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBaseWithoutTimeOutMethod;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import jakarta.ejb.NoMoreTimeoutsException;
import jakarta.ejb.Singleton;
import jakarta.ejb.Timeout;
import jakarta.ejb.Timer;
import java.util.Collection;

@Singleton
public class ScheduleBean
extends TimerBeanBaseWithoutTimeOutMethod {
    @Override
    @Timeout
    protected void timeout(Timer timer) {
        super.timeout(timer);
        TimerInfo info = (TimerInfo)timer.getInfo();
        String testName = info.getTestName();
        if (testName.equals("timerAccessInTimeoutMethod")) {
            this.timerAccessInTimeoutMethod(timer, testName);
        } else if (testName.equals("cancelInTimeoutMethod")) {
            timer.cancel();
        } else if (testName.startsWith("incrementSecond")) {
            long expectedTimeRemaining;
            long margin = 10000L;
            long timeRemaining = timer.getTimeRemaining();
            if (Math.abs(timeRemaining - (expectedTimeRemaining = info.getLongVar().longValue())) <= 10000L) {
                Helper.getLogger().info("Expected timeRemaining: " + expectedTimeRemaining + ", and actual " + timeRemaining + " are close enough for test " + testName);
            } else {
                this.statusSingleton.setStatus(testName, false);
                this.statusSingleton.addRecord(testName, "Expecting timeRemaining " + expectedTimeRemaining + ", actual " + timeRemaining);
            }
        }
    }

    private void timerAccessInTimeoutMethod(Timer t, String testName) {
        Collection timers = this.timerService.getTimers();
        if (timers.size() == 1) {
            this.statusSingleton.addRecord(testName, "Found 1 timer, as expected.");
        } else {
            this.statusSingleton.setStatus(testName, false);
            this.statusSingleton.addRecord(testName, "Expecting 1 timer, but got " + timers.size());
        }
        if (t.isPersistent()) {
            t.getHandle();
        }
        if (t.isCalendarTimer()) {
            t.getSchedule();
        }
        t.isPersistent();
        try {
            t.getNextTimeout();
            this.statusSingleton.setStatus(testName, false);
            this.statusSingleton.addRecord(testName, "Expecting NoMoreTimeoutsException, but got none.");
        }
        catch (NoMoreTimeoutsException e) {
            this.statusSingleton.addRecord(testName, "Got the expected " + (Object)((Object)e));
        }
        try {
            t.getTimeRemaining();
            this.statusSingleton.setStatus(testName, false);
            this.statusSingleton.addRecord(testName, "Expecting NoMoreTimeoutsException, but got none.");
        }
        catch (NoMoreTimeoutsException e) {
            this.statusSingleton.addRecord(testName, "Got the expected " + (Object)((Object)e));
        }
        t.cancel();
        this.statusSingleton.addRecord(testName, "Called various timer methods in timeout method.");
    }
}

