/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonparserfactorytests;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonp.common.JSONP_Util;
import com.sun.ts.tests.jsonp.common.MyBufferedInputStream;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.stream.JsonParser;
import jakarta.json.stream.JsonParserFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Map;
import java.util.Properties;

public class Client
extends ServiceEETest {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void jsonParserFactoryTest1() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            this.logMsg("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("--------------------------------------------------");
            this.logMsg("TEST CASE [JsonParserFactory.createParser(Reader)]");
            this.logMsg("--------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            this.logMsg("Create 1st JsonParser from the Reader using JsonParserFactory");
            parser1 = parserFactory.createParser((Reader)new StringReader(jsonObjectString));
            if (parser1 == null) {
                this.logErr("ParserFactory failed to create parser1 from Reader");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser1, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser1, "foo", "bar");
                JSONP_Util.testEventType(parser1, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonParser from the Reader using JsonParserFactory");
            parser2 = parserFactory.createParser((Reader)new StringReader(jsonObjectString));
            if (parser2 == null) {
                this.logErr("ParserFactory failed to create parser2 from Reader");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser2, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser2, "foo", "bar");
                JSONP_Util.testEventType(parser2, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest1 Failed: ", e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest1 Failed");
        }
    }

    public void jsonParserFactoryTest2() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            this.logMsg("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("------------------------------------------------------");
            this.logMsg("TEST CASE [JsonParserFactory.createParser(JsonObject)]");
            this.logMsg("------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            JsonObject jsonObj = JSONP_Util.createJsonObjectFromString(jsonObjectString);
            this.logMsg("Create 1st JsonParser from the JsonObject using JsonParserFactory");
            parser1 = parserFactory.createParser(jsonObj);
            if (parser1 == null) {
                this.logErr("ParserFactory failed to create parser1 from JsonObject");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser1, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser1, "foo", "bar");
                JSONP_Util.testEventType(parser1, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonParser from the JsonObject using JsonParserFactory");
            parser2 = parserFactory.createParser(jsonObj);
            if (parser2 == null) {
                this.logErr("ParserFactory failed to create parser2 from JsonObject");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser2, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser2, "foo", "bar");
                JSONP_Util.testEventType(parser2, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest2 Failed: ", e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest2 Failed");
        }
    }

    public void jsonParserFactoryTest3() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            this.logMsg("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------------");
            this.logMsg("TEST CASE [JsonParserFactory.createParser(JsonArray)]");
            this.logMsg("-----------------------------------------------------");
            String jsonArrayString = "[\"foo\",\"bar\"]";
            JsonArray jsonArr = JSONP_Util.createJsonArrayFromString(jsonArrayString);
            this.logMsg("Create 1st JsonParser from the JsonArray using JsonParserFactory");
            parser1 = parserFactory.createParser(jsonArr);
            if (parser1 == null) {
                this.logErr("ParserFactory failed to create parser1 from JsonArray");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonArrayString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser1, JsonParser.Event.START_ARRAY);
                JSONP_Util.testStringValue(parser1, "foo");
                JSONP_Util.testStringValue(parser1, "bar");
                JSONP_Util.testEventType(parser1, JsonParser.Event.END_ARRAY);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonParser from the JsonArray using JsonParserFactory");
            parser2 = parserFactory.createParser(jsonArr);
            if (parser2 == null) {
                this.logErr("ParserFactory failed to create parser2 from JsonArray");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonArrayString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser2, JsonParser.Event.START_ARRAY);
                JSONP_Util.testStringValue(parser2, "foo");
                JSONP_Util.testStringValue(parser2, "bar");
                JSONP_Util.testEventType(parser2, JsonParser.Event.END_ARRAY);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest3 Failed: ", e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest3 Failed");
        }
    }

    public void jsonParserFactoryTest4() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            this.logMsg("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-------------------------------------------------------");
            this.logMsg("TEST CASE [JsonParserFactory.createParser(InputStream)]");
            this.logMsg("-------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            this.logMsg("Create 1st JsonParser from the InputStream using JsonParserFactory");
            parser1 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)));
            if (parser1 == null) {
                this.logErr("ParserFactory failed to create parser1 from InputStream");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser1, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser1, "foo", "bar");
                JSONP_Util.testEventType(parser1, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonParser from the InputStream using JsonParserFactory");
            parser2 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)));
            if (parser2 == null) {
                this.logErr("ParserFactory failed to create parser2 from InputStream");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser2, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser2, "foo", "bar");
                JSONP_Util.testEventType(parser2, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest4 Failed: ", e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest4 Failed");
        }
    }

    public void jsonParserFactoryTest5() throws EETest.Fault {
        boolean pass = true;
        JsonParser parser1 = null;
        JsonParser parser2 = null;
        Object event = null;
        try {
            int parseErrs;
            this.logMsg("Create JsonParserFactory with a configuration");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            this.logMsg("Checking factory configuration properties");
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("----------------------------------------------------------------");
            this.logMsg("TEST CASE [JsonParserFactory.createParser(InputStream, Charset)]");
            this.logMsg("----------------------------------------------------------------");
            String jsonObjectString = "{\"foo\":\"bar\"}";
            this.logMsg("Create 1st JsonParser from the InputStream using JsonParserFactory");
            parser1 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)), JSONP_Util.UTF_8);
            if (parser1 == null) {
                this.logErr("ParserFactory failed to create parser1 from InputStream");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser1, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser1, "foo", "bar");
                JSONP_Util.testEventType(parser1, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
            this.logMsg("Create 2nd JsonParser from the InputStream using JsonParserFactory");
            parser2 = parserFactory.createParser((InputStream)new ByteArrayInputStream(jsonObjectString.getBytes(JSONP_Util.UTF_8)), JSONP_Util.UTF_8);
            if (parser2 == null) {
                this.logErr("ParserFactory failed to create parser2 from InputStream");
                pass = false;
            } else {
                this.logMsg("Parsing " + jsonObjectString);
                this.logMsg("Verify that JSON Parser Events/Data matches");
                JSONP_Util.resetParseErrs();
                JSONP_Util.testEventType(parser2, JsonParser.Event.START_OBJECT);
                JSONP_Util.testKeyStringValue(parser2, "foo", "bar");
                JSONP_Util.testEventType(parser2, JsonParser.Event.END_OBJECT);
                parseErrs = JSONP_Util.getParseErrs();
                if (parseErrs != 0) {
                    this.logErr("There were " + parseErrs + " parser errors that occurred.");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest5 Failed: ", e);
        }
        finally {
            try {
                parser1.close();
                parser2.close();
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest5 Failed");
        }
    }

    public void jsonParserFactoryTest6() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("----------------------------------------------");
            this.logMsg("Test scenario1: no supported provider property");
            this.logMsg("----------------------------------------------");
            this.logMsg("Create JsonParserFactory with Map<String, ?> with EMPTY config");
            JsonParserFactory parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            Map config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
            this.logMsg("-----------------------------------------------");
            this.logMsg("Test scenario2: non supported provider property");
            this.logMsg("-----------------------------------------------");
            this.logMsg("Create JsonParserFactory with Map<String, ?> with FOO config");
            parserFactory = Json.createParserFactory(JSONP_Util.getFooConfig());
            config = parserFactory.getConfigInUse();
            if (!JSONP_Util.doConfigCheck(config, 0)) {
                pass = false;
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("jsonParserFactoryTest6 Failed: ", e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryTest6 Failed");
        }
    }

    public void jsonParserFactoryExceptionTest() throws EETest.Fault {
        JsonParser parser;
        JsonParserFactory parserFactory;
        boolean pass = true;
        try {
            this.logMsg("Tests JsonParserFactory.createParser(InputStream) for JsonException if i/o error.");
            parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            MyBufferedInputStream mbi = new MyBufferedInputStream(JSONP_Util.getInputStreamFromString("{}"), true);
            parser = parserFactory.createParser((InputStream)mbi);
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        try {
            this.logMsg("Tests JsonParserFactory.createParser(InputStream) for JsonException if unknown encoding.");
            parserFactory = Json.createParserFactory(JSONP_Util.getEmptyConfig());
            InputStream is = JSONP_Util.getInputStreamFromResource("jsonObjectUnknownEncoding.json");
            parser = parserFactory.createParser(is);
            this.logMsg("parser=" + parser);
            this.logErr("Did not get expected JsonException");
            pass = false;
        }
        catch (JsonException e) {
            this.logMsg("Caught expected JsonException");
        }
        catch (Exception e) {
            pass = false;
            this.logErr("Caught unexpected exception: " + e);
        }
        if (!pass) {
            throw new EETest.Fault("jsonParserFactoryExceptionTest Failed");
        }
    }
}

