/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.core.AppContext;
import com.sun.tdk.signaturetest.core.context.BaseOptions;
import com.sun.tdk.signaturetest.core.context.Option;
import com.sun.tdk.signaturetest.loaders.VirtualClassDescriptionLoader;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.FileManager;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.toyxml.Elem;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class MultipleFileReader
extends VirtualClassDescriptionLoader
implements AutoCloseable {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(MultipleFileReader.class);
    public static final int CLASSPATH_MODE = 1;
    public static final int MERGE_MODE = 2;
    private Iterator<ClassDescription> classIterator = null;
    private PrintWriter log;
    private int mode;
    private String apiVersion;
    private FileManager fileMan;
    private final BaseOptions bo = AppContext.getContext().getBean(BaseOptions.class);
    private List<Elem> elements;

    public MultipleFileReader(PrintWriter log, int mode, FileManager f) {
        assert (mode == 1);
        this.log = log;
        this.mode = mode;
        this.fileMan = f;
    }

    public boolean readSignatureFiles(String testURL, String sigFileList) {
        assert (testURL != null);
        assert (sigFileList != null);
        boolean result = true;
        StringTokenizer st = new StringTokenizer(sigFileList, File.pathSeparator);
        while (st.hasMoreElements() && result) {
            String fileName = st.nextToken();
            result = this.readSignatureFile(testURL, fileName);
        }
        return result;
    }

    public boolean readSignatureFile(String testURL, String sigFileName) {
        boolean result;
        assert (testURL != null);
        assert (sigFileName != null);
        try {
            URL fileURL = FileManager.getURL(testURL, sigFileName);
            result = this.readFile(fileURL);
        }
        catch (MalformedURLException e) {
            if (this.bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            Object[] invargs = new String[]{testURL, e.getMessage()};
            this.log.println(i18n.getString("MultipleFileReader.error.url.threwerror", invargs));
            return false;
        }
        this.rewind();
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean readFile(URL fileURL) {
        String msg = null;
        try (Reader in = this.fileMan.getReader(fileURL);){
            ClassDescription cl;
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            if (!in.readSignatureFile(fileURL)) {
                msg = i18n.getString("MultipleFileReader.error.sigfile.invalid", fileURL);
            }
            if (this.mode == 2 && !in.hasFeature(FeaturesHolder.MergeModeSupported)) {
                throw new IOException(i18n.getString("MultipleFileReader.error.cannt_merge_old_files") + fileURL);
            }
            if (!this.isInitialized()) {
                this.setFeatures(in.getAllSupportedFeatures());
            } else {
                this.retainFeatures(in.getAllSupportedFeatures());
            }
            this.apiVersion = in.getApiVersion();
            while ((cl = in.readNextClass()) != null) {
                String name = cl.getQualifiedName();
                if (this.mode == 1) {
                    try {
                        this.load(name);
                    }
                    catch (ClassNotFoundException ex) {
                        this.add(cl);
                    }
                    continue;
                }
                assert (this.mode == 2);
            }
            this.elements = in.getElems();
        }
        catch (IOException e) {
            if (this.bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.prob") + "\n" + e;
        }
        catch (SecurityException e) {
            if (this.bo.isSet(Option.DEBUG)) {
                SwissKnife.reportThrowable(e);
            }
            msg = i18n.getString("MultipleFileReader.error.sigfile.sec") + "\n" + e;
        }
        if (msg == null) return true;
        this.log.println(msg);
        return false;
    }

    @Override
    public void close() {
        this.classIterator = null;
        this.cleanUp();
    }

    public void rewind() {
        this.classIterator = this.getClassIterator();
    }

    public List<Elem> getElements() {
        return this.elements;
    }

    public ClassDescription nextClass() throws IOException {
        ClassDescription cl = null;
        if (this.classIterator != null && this.classIterator.hasNext()) {
            cl = this.classIterator.next();
        }
        return cl;
    }

    public String getApiVersion() {
        return this.apiVersion;
    }
}

