/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.model;

import com.sun.tdk.signaturetest.core.PrimitiveTypes;
import com.sun.tdk.signaturetest.model.AnnotationItem;
import com.sun.tdk.signaturetest.model.ExoticCharTools;
import com.sun.tdk.signaturetest.model.MemberType;
import com.sun.tdk.signaturetest.model.Modifier;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Set;
import java.util.StringTokenizer;

public abstract class MemberDescription
implements Cloneable,
Serializable {
    public static final String EMPTY_THROW_LIST = "";
    public static final String NO_ARGS = "";
    public static final String NO_TYPE = "";
    public static final String NO_DECLARING_CLASS = "";
    public static final String THROWS_DELIMITER = ",";
    public static final String ARGS_DELIMITER = ",";
    public static final String JAVA_LANG = "java.lang";
    public static final char CLASS_DELIMITER = '$';
    public static final char MEMBER_DELIMITER = '.';
    protected final char delimiter;
    private int modifiers = 0;
    String typeParameters;
    String type = "";
    String declaringClass = "";
    String args = "";
    String throwables = "";
    private AnnotationItem[] annoList = AnnotationItem.EMPTY_ANNOTATIONITEM_ARRAY;
    MemberType memberType;
    String name = "";
    private boolean marked = false;

    protected MemberDescription(MemberType memberType, char delimiter) {
        this.memberType = memberType;
        this.delimiter = delimiter;
    }

    public final Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            SwissKnife.reportThrowable(e);
            return null;
        }
    }

    public MemberType getMemberType() {
        return this.memberType;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        int hash = 5;
        hash = 23 * hash + (this.type != null ? this.type.hashCode() : 0);
        hash = 23 * hash + (this.declaringClass != null ? this.declaringClass.hashCode() : 0);
        hash = 23 * hash + (this.memberType != null ? this.memberType.hashCode() : 0);
        hash = 23 * hash + (this.name != null ? this.name.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MemberDescription other = (MemberDescription)obj;
        return this.type.equals(other.type) && this.declaringClass.equals(other.declaringClass) && this.memberType.equals(other.memberType) && this.name.equals(other.name);
    }

    public boolean isClass() {
        return false;
    }

    public boolean isSuperClass() {
        return false;
    }

    public boolean isSuperInterface() {
        return false;
    }

    public boolean isField() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isInner() {
        return false;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public String getType() {
        return this.type;
    }

    public String getTypeParameters() {
        return this.typeParameters;
    }

    public void setupGenericClassName(String superClassName, String outer) {
        int pos = superClassName.indexOf(60);
        String tmp = superClassName;
        if (pos != -1) {
            tmp = superClassName.substring(0, pos);
            this.typeParameters = superClassName.substring(pos);
        } else {
            this.typeParameters = null;
        }
        this.setupClassName(tmp, outer);
    }

    public void setupGenericClassName(String superClassName) {
        int pos = superClassName.indexOf(60);
        String tmp = superClassName;
        if (pos != -1) {
            tmp = superClassName.substring(0, pos);
            this.typeParameters = superClassName.substring(pos);
        } else {
            this.typeParameters = null;
        }
        this.setupClassName(tmp);
    }

    public void setupClassName(String fqn, String outerName) {
        fqn = ExoticCharTools.encodeExotic(fqn);
        outerName = ExoticCharTools.encodeExotic(outerName);
        if (this.memberType == MemberType.CLASS || this.memberType == MemberType.SUPERCLASS || this.memberType == MemberType.SUPERINTERFACE) {
            this.name = fqn.intern();
        } else {
            if (!outerName.equals("") && fqn.startsWith(outerName) && !outerName.equals(fqn)) {
                this.name = fqn.substring(outerName.length());
                if (this.name.charAt(0) == this.delimiter) {
                    this.name = this.name.substring(1);
                }
            } else {
                this.name = fqn;
            }
            this.name = this.name.intern();
        }
        this.declaringClass = !outerName.equals("") && !outerName.equals(fqn) ? outerName.intern() : "";
    }

    public void setupClassName(String fqn) {
        fqn = ExoticCharTools.encodeExotic(fqn);
        int delimPos = fqn.lastIndexOf(this.delimiter);
        if (this.memberType == MemberType.CLASS || this.memberType == MemberType.SUPERCLASS || this.memberType == MemberType.SUPERINTERFACE) {
            this.name = fqn.intern();
            this.declaringClass = delimPos != -1 ? fqn.substring(0, delimPos).intern() : "";
        } else {
            if (delimPos >= 0) {
                this.declaringClass = fqn.substring(0, delimPos).intern();
            }
            this.name = fqn.substring(delimPos + 1).intern();
        }
    }

    public void setupInnerClassName(String name, String declaringClassName) {
        this.declaringClass = declaringClassName.intern();
        this.name = name.intern();
    }

    public void setupMemberName(String own, String dcl) {
        this.declaringClass = dcl.intern();
        own = ExoticCharTools.encodeExotic(own);
        this.name = own.intern();
    }

    public void setupMemberName(String fqn) {
        int pos = fqn.lastIndexOf(this.delimiter);
        this.declaringClass = fqn.substring(0, pos).intern();
        this.name = fqn.substring(pos + 1).intern();
    }

    public String getDeclaringClassName() {
        return this.declaringClass;
    }

    public AnnotationItem[] getAnnoList() {
        return this.annoList;
    }

    public String getQualifiedName() {
        return this.declaringClass + this.delimiter + this.name;
    }

    public String getThrowables() {
        return this.throwables;
    }

    public void mark() {
        this.marked = true;
    }

    public void unmark() {
        this.marked = false;
    }

    public boolean isMarked() {
        return this.marked;
    }

    public boolean isProtected() {
        return Modifier.hasModifier(this.modifiers, Modifier.PROTECTED);
    }

    public boolean isPublic() {
        return Modifier.hasModifier(this.modifiers, Modifier.PUBLIC);
    }

    public boolean isPrivate() {
        return Modifier.hasModifier(this.modifiers, Modifier.PRIVATE);
    }

    public boolean isAbstract() {
        return Modifier.hasModifier(this.modifiers, Modifier.ABSTRACT);
    }

    public boolean isStatic() {
        return Modifier.hasModifier(this.modifiers, Modifier.STATIC);
    }

    public boolean isFinal() {
        return Modifier.hasModifier(this.modifiers, Modifier.FINAL);
    }

    public boolean isInterface() {
        return Modifier.hasModifier(this.modifiers, Modifier.INTERFACE);
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "";
        }
        if (value.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            int n = Array.getLength(value);
            for (int i = 0; i < n; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(MemberDescription.valueToString(Array.get(value, i)));
            }
            sb.append(']');
            return sb.toString();
        }
        if (value instanceof Character) {
            return "'" + MemberDescription.stuffOut(value.toString()) + "'";
        }
        if (value instanceof String) {
            return "\"" + MemberDescription.stuffOut(value.toString()) + "\"";
        }
        if (value instanceof Long) {
            return value.toString();
        }
        if (value instanceof Float) {
            Float f = (Float)value;
            return f.toString();
        }
        if (value instanceof Double) {
            Double d = (Double)value;
            return d.toString();
        }
        return value.toString();
    }

    private static String stuffOut(String s) {
        StringBuffer x = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (' ' <= c && c <= '~' && c != '\"' && c != '\\') {
                x.append(c);
                continue;
            }
            if (c == '\r') {
                x.append("\\r");
                continue;
            }
            if (c == '\n') {
                x.append("\\n");
                continue;
            }
            x.append(MemberDescription.esc(c));
        }
        return x.toString();
    }

    private static String esc(char c) {
        String s = Integer.toHexString(c);
        int n = s.length();
        if (n == 1) {
            return "\\u000" + s;
        }
        if (n == 2) {
            return "\\u00" + s;
        }
        if (n == 3) {
            return "\\u0" + s;
        }
        return "\\u" + s;
    }

    public void setModifiers(int access) {
        int mask = this.memberType.getModifiersMask();
        if ((access & mask) != access) {
            throw new ClassFormatError("Unknown modifier(s) found " + (access & ~mask));
        }
        this.modifiers = access;
        if (Modifier.hasModifier(this.modifiers, Modifier.INTERFACE)) {
            this.modifiers = Modifier.addModifier(this.modifiers, Modifier.ABSTRACT);
        }
    }

    public void addModifier(Modifier mod) {
        this.modifiers = Modifier.addModifier(this.modifiers, mod);
    }

    public void removeModifier(Modifier mod) {
        this.modifiers = Modifier.removeModifier(this.modifiers, mod);
    }

    public static String getTypeName(Class<?> c) {
        String className = c.getName();
        if (!className.startsWith("[")) {
            return className;
        }
        return MemberDescription.getTypeName(className);
    }

    public static String getTypeName(String className) {
        StringBuffer sb = new StringBuffer();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        String type = className.charAt(dims) == 'L' ? className.substring(dims + 1, className.length() - 1) : PrimitiveTypes.getPrimitiveType(className.charAt(dims));
        sb.append(type);
        for (int i = 0; i < dims; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public String getArgs() {
        return this.args;
    }

    public String getSimplifiedType() {
        return this.simplifyType(this.type);
    }

    public String getSimplifiedArgs() {
        if (this.args == null || this.args.isEmpty()) {
            return this.args;
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.args, ",");
        while (st.hasMoreTokens()) {
            sb.append(this.simplifyType(st.nextToken().trim()));
            if (!st.hasMoreTokens()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private String simplifyType(String type) {
        String pack = MemberDescription.getPackageName(type);
        String thisPack = MemberDescription.getPackageName(this.getDeclaringClassName());
        if (pack.equals(JAVA_LANG) || pack.equals(thisPack)) {
            return MemberDescription.getClassShortName(type);
        }
        return type;
    }

    public boolean setType(String type) {
        if (this.type.equals(type)) {
            return false;
        }
        this.type = type.intern();
        return true;
    }

    public boolean setArgs(String args) {
        if (this.args.equals(args)) {
            return false;
        }
        this.args = !args.contains(",") ? args.intern() : args;
        return true;
    }

    public boolean setThrowables(String throwables) {
        if (this.throwables.equals(throwables)) {
            return false;
        }
        this.throwables = !throwables.contains(",") ? throwables.intern() : throwables;
        return true;
    }

    public void setAnnoList(AnnotationItem[] annoList) {
        this.annoList = annoList;
        if (annoList.length > 1) {
            Arrays.sort(this.annoList);
        }
    }

    public void setTypeParameters(String typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void setDeclaringClass(String declaringClass) {
        if (declaringClass == null || "".equals(declaringClass)) {
            throw new IllegalArgumentException();
        }
        this.declaringClass = declaringClass.intern();
    }

    public void setNoDeclaringClass() {
        this.declaringClass = "";
    }

    public static String getThrows(String[] xthrows) {
        if (xthrows == null || xthrows.length == 0) {
            return "";
        }
        if (xthrows.length > 1) {
            Arrays.sort(xthrows);
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < xthrows.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(xthrows[i]);
        }
        return sb.toString();
    }

    public boolean hasModifier(Modifier mod) {
        return Modifier.hasModifier(this.modifiers, mod);
    }

    public abstract boolean isCompatible(MemberDescription var1);

    protected void populateDependences(Set<String> dependences) {
    }

    protected void addDependency(Set<String> dependences, String newDependency) {
        if (newDependency.charAt(0) == '{') {
            return;
        }
        String temp = newDependency;
        int pos = temp.indexOf(60);
        if (pos != -1) {
            temp = temp.substring(0, pos);
        }
        if ((pos = temp.indexOf(91)) != -1) {
            temp = temp.substring(0, pos);
        }
        if (PrimitiveTypes.isPrimitive(newDependency)) {
            return;
        }
        dependences.add(temp);
    }

    public static String getClassShortName(String fqn) {
        String result = fqn;
        int pos = Math.max(fqn.lastIndexOf(46), fqn.lastIndexOf(36));
        if (pos != -1) {
            result = fqn.substring(pos + 1);
        }
        return result;
    }

    protected static String getPackageName(String fqn) {
        String result = fqn;
        int pos = fqn.lastIndexOf(46);
        if (pos != -1) {
            result = fqn.substring(0, pos);
        }
        return result;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.memberType = MemberType.getItemType(this.memberType.toString());
        this.setupMemberName(this.name, this.declaringClass);
        this.setArgs(this.args);
        this.setThrowables(this.throwables);
    }
}

