/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.spec.ContextService.tx;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.spec.ContextService.tx.Util;
import jakarta.annotation.Resource;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import javax.sql.DataSource;

public class Client
extends EETest {
    private String host = null;
    private int port;
    private Properties props = null;
    private String appendedURL = "";
    private String username;
    private String password;
    private String tablename;
    @Resource(lookup="jdbc/DB1")
    private static DataSource ds;
    private Connection conn;
    private static final String CONTEXT_PATH = "/concurrency_spec_ContextService_tx_web";
    private String testURL;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"setup");
        try {
            this.port = Integer.parseInt(p.getProperty("webServerPort"));
            this.host = p.getProperty("webServerHost");
            if (this.port < 1) {
                throw new Exception("'port' in ts.jte must be > 0");
            }
            if (this.host == null) {
                throw new Exception("'host' in ts.jte must not be null ");
            }
            this.props = new Properties(p);
            this.tablename = (String)p.get("concurrencetable");
            this.appendedURL = this.appendedURL(p);
            this.username = p.getProperty("user1");
            this.password = p.getProperty("password1");
            this.testURL = "http://" + this.host + ":" + this.port + CONTEXT_PATH + "/TxServlet" + this.appendedURL;
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed!", e);
        }
    }

    public void testTransactionOfExecuteThreadAndCommit() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(this.testURL + "&methodname=TransactionOfExecuteThreadAndCommitTest");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The result is : " + resp);
        if (resp == null || !"3".equals(resp.trim())) {
            throw new EETest.Fault("testTransactionOfExecuteThreadAndCommit fail to get successful result.");
        }
    }

    public void testTransactionOfExecuteThreadAndRollback() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(this.testURL + "&methodname=TransactionOfExecuteThreadAndRollbackTest");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The result is : " + resp);
        if (resp == null || !"0".equals(resp.trim())) {
            throw new EETest.Fault("testTransactionOfExecuteThreadAndRollback fail to get successful result.");
        }
    }

    public void testSuspendAndCommit() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(this.testURL + "&methodname=SuspendAndCommitTest");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The result is : " + resp);
        if (resp == null || !"1".equals(resp.trim())) {
            throw new EETest.Fault("testSuspendAndCommit fail to get successful result.");
        }
    }

    public void testSuspendAndRollback() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(this.testURL + "&methodname=SuspendAndRollbackTest");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The result is : " + resp);
        if (resp == null || !"2".equals(resp.trim())) {
            throw new EETest.Fault("testSuspendAndRollback fail to get successful result.");
        }
    }

    public void testDefaultAndCommit() throws EETest.Fault {
        String resp = null;
        try {
            URL url = new URL(this.testURL + "&methodname=DefaultAndCommitTest");
            resp = TestUtil.getResponse((URLConnection)url.openConnection());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("The result is : " + resp);
        if (resp == null || !"1".equals(resp.trim())) {
            throw new EETest.Fault("testDefaultAndCommit fail to get successful result.");
        }
    }

    private String appendedURL(Properties p) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer("?");
        sb.append("user1=" + p.get("user1"));
        sb.append("&");
        sb.append("password1=" + p.get("password1"));
        sb.append("&");
        sb.append("concurrencetable=concurrencetable");
        sb.append("&");
        sb.append("Dbschema_Concur_Insert=" + URLEncoder.encode(p.get("Dbschema_Concur_Insert").toString(), "utf8"));
        return sb.toString();
    }

    public void cleanup() throws EETest.Fault {
        try {
            this.removeTestData();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EETest.Fault("cleanup failed.", e);
        }
        TestUtil.logTrace((String)"test cleanup ok");
    }

    private void removeTestData() throws RemoteException {
        TestUtil.logTrace((String)"removeTestData");
        this.conn = Util.getConnection(ds, this.username, this.password, true);
        String removeString = this.props.getProperty("Dbschema_Concur_Delete", "");
        try {
            Statement stmt = this.conn.createStatement();
            stmt.executeUpdate(removeString);
            stmt.close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RemoteException(e.getMessage());
        }
        finally {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

