/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.jsonwritertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonException;
import jakarta.json.JsonValue;
import jakarta.json.JsonWriter;
import jakarta.json.stream.JsonParser;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;

public class Writer {
    private static final Object[] VALUES = new Object[]{SimpleValues.OBJ_VALUE, SimpleValues.createEmptyArrayWithStr(), "In a galaxy far far away", 42, 9223372036854775765L, 3.441073578556931E305, SimpleValues.BIN_VALUE, SimpleValues.BDC_VALUE, true, null};

    Writer() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonWriter API methods added in JSON-P 1.1.");
        TestUtil.logMsg((String)"JsonWriter API methods added in JSON-P 1.1.");
        this.testWriteValue(result);
        this.testDoubleWriteValue(result);
        this.testIOExceptionOnWriteValue(result);
        return result;
    }

    private void testWriteValue(TestResult result) {
        for (Object value : VALUES) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - write(JsonValue) for " + typeName + " as an argument"));
            JsonValue jsonValue = SimpleValues.toJsonValue(value);
            StringWriter strWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)strWriter);){
                writer.write(jsonValue);
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("write(JsonValue)", "Caught JsonException: " + ex.getLocalizedMessage());
            }
            String data = strWriter.toString();
            TestUtil.logMsg((String)("    - Data: " + data));
            JsonParser parser = Json.createParser((Reader)new StringReader(data));
            parser.next();
            JsonValue outValue = parser.getValue();
            if (!this.operationFailed(jsonValue, outValue)) continue;
            result.fail("write(JsonValue)", "Writer output " + JsonAssert.valueToString(outValue) + " value shall be " + JsonAssert.valueToString(jsonValue));
        }
    }

    private void testDoubleWriteValue(TestResult result) {
        for (Object value : VALUES) {
            String typeName = JsonValueType.getType(value).name();
            TestUtil.logMsg((String)(" - duplicate write(JsonValue) for " + typeName + " as an argument"));
            JsonValue jsonValue = SimpleValues.toJsonValue(value);
            StringWriter strWriter = new StringWriter();
            try (JsonWriter writer = Json.createWriter((java.io.Writer)strWriter);){
                writer.write(jsonValue);
                try {
                    writer.write(jsonValue);
                    result.fail("write(JsonValue)", "Duplicate call of write(JsonValue) shall throw IllegalStateException");
                }
                catch (IllegalStateException ex) {
                    TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
                }
                catch (Throwable t) {
                    result.fail("write(JsonValue)", "Duplicate call of write(JsonValue) shall throw IllegalStateException, not " + t.getClass().getSimpleName());
                }
            }
            catch (JsonException ex) {
                TestUtil.logMsg((String)("Caught JsonException: " + ex.getLocalizedMessage()));
                result.fail("write(JsonValue)", "Caught JsonException: " + ex.getLocalizedMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testIOExceptionOnWriteValue(TestResult result) {
        JsonWriter writer;
        TestUtil.logMsg((String)" - write(JsonValue) into already closed file writer");
        JsonValue jsonValue = SimpleValues.toJsonValue("John Smith");
        File temp = null;
        try {
            temp = File.createTempFile("testIOExceptionOnWriteValue", ".txt");
            TestUtil.logMsg((String)("    - Temporary file: " + temp.getAbsolutePath()));
            FileWriter fileWriter = new FileWriter(temp);
            writer = Json.createWriter((java.io.Writer)fileWriter);
            fileWriter.close();
        }
        catch (IOException ex) {
            TestUtil.logMsg((String)("Caught IOException: " + ex.getLocalizedMessage()));
            result.fail("write(JsonValue)", "Caught IOException: " + ex.getLocalizedMessage());
            return;
        }
        finally {
            if (temp != null) {
                temp.delete();
            }
        }
        try {
            writer.write(jsonValue);
            result.fail("write(JsonValue)", "Call of write(JsonValue) on already closed file writer shall throw JsonException");
        }
        catch (JsonException ex) {
            TestUtil.logMsg((String)("    - Expected exception: " + ex.getMessage()));
        }
        catch (Throwable t) {
            result.fail("write(JsonValue)", "Call of write(JsonValue) on already closed file writer shall throw JsonException, not " + t.getClass().getSimpleName());
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null || !JsonAssert.assertEquals(check, out);
    }
}

