/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.bm.allowed;

import com.sun.ts.tests.ejb30.bb.session.stateful.bm.allowed.AllowedBeanNonSessionSynchronizationBase;
import com.sun.ts.tests.ejb30.bb.session.stateful.bm.allowed.StatefulBMTOperations;
import com.sun.ts.tests.ejb30.common.allowed.AllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.AllowedLocalIF;
import com.sun.ts.tests.ejb30.common.allowed.stateful.StatefulCancelInterceptor;
import com.sun.ts.tests.ejb30.common.allowed.stateful.TimerLocalIF;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.ejb.Local;
import jakarta.ejb.Remote;
import jakarta.ejb.Remove;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Stateful;
import jakarta.ejb.TransactionManagement;
import jakarta.ejb.TransactionManagementType;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptors;
import jakarta.interceptor.InvocationContext;
import jakarta.transaction.NotSupportedException;
import java.io.Serializable;
import java.util.Properties;

@Stateful(name="AllowedBean")
@Remote(value={AllowedIF.class})
@Local(value={AllowedLocalIF.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
@Interceptors(value={StatefulCancelInterceptor.class})
@EJB(name="ejb/TimerEJB", beanName="TimerEJB", beanInterface=TimerLocalIF.class)
public class AllowedBean
extends AllowedBeanNonSessionSynchronizationBase
implements AllowedIF,
AllowedLocalIF,
Serializable {
    @Override
    @Resource(name="ejbContext")
    public void setSessionContext(SessionContext sc) {
        super.setSessionContext(sc);
    }

    @Override
    @AroundInvoke
    public Object intercept(InvocationContext inv) throws Exception {
        return super.intercept(inv);
    }

    @Override
    public Properties runOperations(SessionContext sctx) {
        return StatefulBMTOperations.getInstance().run2(sctx, AllowedIF.class);
    }

    @Override
    @Remove
    public void remove() {
        super.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void utBeginTest() throws TestFailedException {
        boolean pass = false;
        String reason = null;
        try {
            this.sessionContext.getUserTransaction().begin();
            TLogger.logMsg("UserTransaction.begin - allowed");
            TLogger.logTrace("Attempt to call begin again before commit() or rollback()");
            this.sessionContext.getUserTransaction().begin();
            reason = "Was able to call begin again before commit() or rollback()";
        }
        catch (NotSupportedException nse) {
            pass = true;
            reason = "jakarta.transaction.NotSupportedException caught as expected";
            TLogger.log(reason);
        }
        catch (Exception e) {
            reason = "Unexpected Exception - " + e;
        }
        finally {
            try {
                if (this.sessionContext.getUserTransaction().getStatus() != 6) {
                    TLogger.logTrace("Rollback the active TX from the first begin call");
                    this.sessionContext.getUserTransaction().rollback();
                }
            }
            catch (Exception re) {
                TLogger.logMsg("Exception caught on ut.rollback() - " + re);
            }
        }
        if (!pass) {
            throw new TestFailedException(reason);
        }
    }
}

