/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util.json;

import com.unboundid.util.NotMutable;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.json.JSONBuffer;
import com.unboundid.util.json.JSONValue;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class JSONBoolean
extends JSONValue {
    public static final JSONBoolean FALSE = new JSONBoolean(false);
    public static final JSONBoolean TRUE = new JSONBoolean(true);
    private static final long serialVersionUID = -5090296701442873481L;
    private final boolean booleanValue;
    private final String stringRepresentation;

    public JSONBoolean(boolean booleanValue) {
        this.booleanValue = booleanValue;
        this.stringRepresentation = booleanValue ? "true" : "false";
    }

    public boolean booleanValue() {
        return this.booleanValue;
    }

    @Override
    public int hashCode() {
        return this.booleanValue ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof JSONBoolean) {
            JSONBoolean b = (JSONBoolean)o;
            return b.booleanValue == this.booleanValue;
        }
        return false;
    }

    @Override
    public boolean equals(JSONValue v, boolean ignoreFieldNameCase, boolean ignoreValueCase, boolean ignoreArrayOrder) {
        return v instanceof JSONBoolean && this.booleanValue == ((JSONBoolean)v).booleanValue;
    }

    @Override
    public String toString() {
        return this.stringRepresentation;
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }

    @Override
    public String toSingleLineString() {
        return this.stringRepresentation;
    }

    @Override
    public void toSingleLineString(StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }

    @Override
    public String toNormalizedString() {
        return this.stringRepresentation;
    }

    @Override
    public void toNormalizedString(StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }

    @Override
    public void appendToJSONBuffer(JSONBuffer buffer) {
        buffer.appendBoolean(this.booleanValue);
    }

    @Override
    public void appendToJSONBuffer(String fieldName, JSONBuffer buffer) {
        buffer.appendBoolean(fieldName, this.booleanValue);
    }
}

