/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateful.statetest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateful.statetest.InvalidTransactionException;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.SessionBean;
import jakarta.ejb.SessionContext;
import jakarta.ejb.SessionSynchronization;
import java.util.Properties;

public class CounterEJB
implements SessionBean,
SessionSynchronization {
    public int number;
    public int value;
    public boolean rollBackStatusFlag = false;
    public boolean bval = false;
    public boolean firstFlag = true;
    private SessionContext sctx;
    private Properties props;
    private Properties harnessProps;

    public void ejbCreate() throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.number = 1;
        this.value = 0;
        this.bval = false;
        TestUtil.logMsg((String)"counter object created");
        TestUtil.logMsg((String)("number\t= " + this.number));
        TestUtil.logMsg((String)("value\t= " + this.value));
    }

    public void ejbCreate(int n, int v) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        this.number = n;
        this.value = v;
        this.bval = false;
        TestUtil.logMsg((String)"counter object created");
        TestUtil.logMsg((String)("number\t= " + this.number));
        TestUtil.logMsg((String)("value\t= " + this.value));
    }

    public void setSessionContext(SessionContext sctx) {
        TestUtil.logTrace((String)"setSessionContext");
        this.sctx = sctx;
    }

    public void ejbRemove() {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void afterBegin() {
        TestUtil.logMsg((String)"**********************************************");
        TestUtil.logMsg((String)("afterBegin() : " + this.getClass().getName()));
        TestUtil.logMsg((String)"**********************************************");
    }

    public void beforeCompletion() {
        TestUtil.logMsg((String)"**********************************************");
        TestUtil.logMsg((String)("beforeCompletion() : " + this.getClass().getName()));
        TestUtil.logMsg((String)"**********************************************");
    }

    public void afterCompletion(boolean status) {
        if (this.firstFlag) {
            TestUtil.logMsg((String)"This is the first time through afterCompletion");
            this.rollBackStatusFlag = status;
            this.firstFlag = false;
        }
        TestUtil.logMsg((String)"**********************************************");
        TestUtil.logMsg((String)("afterCompletion status [" + status + "] : " + this.getClass().getName()));
        TestUtil.logMsg((String)"**********************************************");
    }

    public int decrement() throws InvalidTransactionException {
        TestUtil.logTrace((String)"decrement");
        if (this.value - 1 < 0) {
            throw new InvalidTransactionException("attempt to set counter to negative value");
        }
        TestUtil.logMsg((String)("counter value before transaction: " + this.value));
        TestUtil.logMsg((String)"decrement counter by 1");
        --this.value;
        TestUtil.logMsg((String)("counter value after transaction: " + this.value));
        return this.value;
    }

    public int decrement(int n) throws InvalidTransactionException {
        TestUtil.logTrace((String)"decrement");
        if (this.value - n < 0) {
            throw new InvalidTransactionException("attempt to set counter to negative value");
        }
        TestUtil.logMsg((String)("counter value before transaction: " + this.value));
        TestUtil.logMsg((String)("decrement counter by " + n));
        this.value -= n;
        TestUtil.logMsg((String)("counter value after transaction: " + this.value));
        return this.value;
    }

    public int increment() {
        TestUtil.logTrace((String)"increment");
        TestUtil.logMsg((String)("counter value before transaction: " + this.value));
        TestUtil.logMsg((String)"increment counter by 1");
        ++this.value;
        TestUtil.logMsg((String)("counter value after transaction: " + this.value));
        return this.value;
    }

    public int increment(int n) {
        TestUtil.logTrace((String)"increment");
        TestUtil.logMsg((String)("counter value before transaction: " + this.value));
        TestUtil.logMsg((String)("increment counter by " + n));
        this.value += n;
        TestUtil.logMsg((String)("counter value after transaction: " + this.value));
        return this.value;
    }

    public int value() {
        TestUtil.logTrace((String)"value");
        TestUtil.logMsg((String)("counter value: " + this.value));
        return this.value;
    }

    public boolean getVal() {
        return this.bval;
    }

    public void setVal() {
        TestUtil.logMsg((String)"This is in the setVal");
        TestUtil.logMsg((String)"setRollbackOnly being set.");
        this.bval = true;
        this.sctx.setRollbackOnly();
    }

    public boolean getRollBackStatus() {
        return this.rollBackStatusFlag;
    }

    public void initLogging(Properties p) {
        TestUtil.logTrace((String)"initLogging");
        this.harnessProps = p;
        try {
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException(e.getMessage());
        }
    }
}

