/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.concurrent.CompletableFuture;
import jdk.incubator.http.ConnectionPool;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.HttpClientImpl;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.MultiExchange;
import jdk.incubator.http.PlainHttpConnection;
import jdk.incubator.http.Response;
import jdk.incubator.http.internal.common.ByteBufferReference;
import jdk.incubator.http.internal.common.MinimalFuture;

class PlainTunnelingConnection
extends HttpConnection {
    final PlainHttpConnection delegate;
    protected final InetSocketAddress proxyAddr;
    private volatile boolean connected;

    @Override
    public CompletableFuture<Void> connectAsync() {
        return this.delegate.connectAsync().thenCompose(void_ -> {
            HttpRequestImpl httpRequestImpl = new HttpRequestImpl("CONNECT", this.client, this.address);
            MultiExchange multiExchange = new MultiExchange((HttpRequest)httpRequestImpl, this.client, this::ignore);
            return multiExchange.responseAsync().thenCompose(httpResponseImpl -> {
                MinimalFuture minimalFuture = new MinimalFuture();
                if (httpResponseImpl.statusCode() != 200) {
                    minimalFuture.completeExceptionally(new IOException("Tunnel failed"));
                } else {
                    this.connected = true;
                    minimalFuture.complete(null);
                }
                return minimalFuture;
            });
        });
    }

    private HttpResponse.BodyProcessor<Void> ignore(int n, HttpHeaders httpHeaders) {
        return HttpResponse.BodyProcessor.discard(null);
    }

    @Override
    public void connect() throws IOException, InterruptedException {
        this.delegate.connect();
        HttpRequestImpl httpRequestImpl = new HttpRequestImpl("CONNECT", this.client, this.address);
        MultiExchange multiExchange = new MultiExchange((HttpRequest)httpRequestImpl, this.client, HttpResponse.BodyHandler.discard(null));
        Exchange<Object> exchange = new Exchange<Object>(httpRequestImpl, multiExchange);
        Response response = exchange.responseImpl(this.delegate);
        if (response.statusCode() != 200) {
            throw new IOException("Tunnel failed");
        }
        this.connected = true;
    }

    @Override
    boolean connected() {
        return this.connected;
    }

    protected PlainTunnelingConnection(InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, HttpClientImpl httpClientImpl) {
        super(inetSocketAddress, httpClientImpl);
        this.proxyAddr = inetSocketAddress2;
        this.delegate = new PlainHttpConnection(inetSocketAddress2, httpClientImpl);
    }

    @Override
    SocketChannel channel() {
        return this.delegate.channel();
    }

    @Override
    ConnectionPool.CacheKey cacheKey() {
        return new ConnectionPool.CacheKey(null, this.proxyAddr);
    }

    @Override
    long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        return this.delegate.write(byteBufferArray, n, n2);
    }

    @Override
    long write(ByteBuffer byteBuffer) throws IOException {
        return this.delegate.write(byteBuffer);
    }

    @Override
    void writeAsync(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.delegate.writeAsync(byteBufferReferenceArray);
    }

    @Override
    void writeAsyncUnordered(ByteBufferReference[] byteBufferReferenceArray) throws IOException {
        this.delegate.writeAsyncUnordered(byteBufferReferenceArray);
    }

    @Override
    void flushAsync() throws IOException {
        this.delegate.flushAsync();
    }

    @Override
    public void close() {
        this.delegate.close();
        this.connected = false;
    }

    @Override
    void shutdownInput() throws IOException {
        this.delegate.shutdownInput();
    }

    @Override
    void shutdownOutput() throws IOException {
        this.delegate.shutdownOutput();
    }

    @Override
    CompletableFuture<Void> whenReceivingResponse() {
        return this.delegate.whenReceivingResponse();
    }

    @Override
    protected ByteBuffer readImpl() throws IOException {
        return this.delegate.readImpl();
    }

    @Override
    boolean isSecure() {
        return false;
    }

    @Override
    boolean isProxied() {
        return true;
    }
}

