/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.ClientBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.ClientBeanHome;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.session.stateless.reentranttest.TestBeanHome;
import java.rmi.RemoteException;
import java.util.Properties;

public class Client
extends EETest
implements Runnable {
    private static final String testName = "ReEntrantTest";
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String clientLookup = "java:comp/env/ejb/ClientBean";
    private static final int SLEEP_TIME = 10000;
    private TestBean beanRef = null;
    private TestBeanHome beanHome = null;
    private ClientBean beanRef2 = null;
    private ClientBeanHome beanHome2 = null;
    private Properties props = null;
    private TSNamingContext nctx = null;
    private int successes = 0;
    private boolean isRemote = true;

    @Override
    public void run() {
        this.logMsg("Thread: " + Thread.currentThread().getName());
        try {
            this.beanRef.sleep(10000);
            this.incrementSuccesses();
        }
        catch (RemoteException e) {
            this.logErr("Thread: " + Thread.currentThread().getName() + ", Exception: " + e, e);
        }
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testLookup, TestBeanHome.class);
            TestUtil.logMsg((String)"Looking up home interface for ClientBean EJB: java:comp/env/ejb/ClientBean");
            this.beanHome2 = (ClientBeanHome)this.nctx.lookup(clientLookup, ClientBeanHome.class);
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = false;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create();
            this.beanRef.initLogging(this.props);
            this.logMsg("Creating Threads T1 and T2");
            Thread t1 = new Thread((Runnable)this, "T1");
            Thread t2 = new Thread((Runnable)this, "T2");
            this.logMsg("Starting Threads T1 and T2");
            t1.start();
            t2.start();
            try {
                t1.join();
            }
            catch (Exception je) {
                TestUtil.logMsg((String)"test1: Unexpected Exception caught during t1.join");
                je.printStackTrace();
            }
            try {
                t2.join();
            }
            catch (Exception le) {
                TestUtil.logMsg((String)"test1: Unexpected Exception caught during t2.join");
                le.printStackTrace();
            }
            this.logMsg("check to ensure both threads succeed - reentrant");
            if (this.successes != 2) {
                pass = false;
                this.logMsg("ERROR: test1 - did not get the expected results, Expected successes = 2, got: " + this.successes);
            } else {
                pass = true;
                this.logMsg("test1 - Expected results received, Expected successes = 2, got: " + this.successes);
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test1 failed", e);
        }
        finally {
            try {
                if (null != this.beanRef) {
                    this.beanRef.remove();
                }
            }
            catch (Exception re) {
                TestUtil.logMsg((String)"Exception caught while removing bean");
                re.printStackTrace();
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    public void test2() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create();
            this.beanRef.initLogging(this.props);
            this.logMsg("Calling loopback test via same bean");
            boolean pass = this.beanRef.loopBackSameBean();
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test2 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test2 failed", e);
        }
    }

    public void test3() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create();
            this.beanRef.initLogging(this.props);
            this.logMsg("Calling loopback test via different bean");
            boolean pass = this.beanRef.loopBackAnotherBean(this.props);
            this.beanRef.remove();
            if (!pass) {
                throw new EETest.Fault("test3 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test3 failed", e);
        }
    }

    public void test4() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef2 = this.beanHome2.create(this.props);
            this.logMsg("Calling loopback test via same bean");
            boolean pass = this.beanRef2.loopBackSameBeanLocal();
            this.beanRef2.remove();
            if (!pass) {
                throw new EETest.Fault("test4 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test4 failed", e);
        }
    }

    public void test5() throws EETest.Fault {
        try {
            this.logMsg("Create EJB instance");
            this.beanRef2 = this.beanHome2.create(this.props);
            this.logMsg("Calling loopback test via different bean");
            boolean pass = this.beanRef2.loopBackAnotherBeanLocal();
            this.beanRef2.remove();
            if (!pass) {
                throw new EETest.Fault("test5 failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("test5 failed", e);
        }
    }

    private synchronized void incrementSuccesses() {
        ++this.successes;
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }
}

