/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonValueType;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.patchtests.CommonOperation;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonObject;
import jakarta.json.JsonPatchBuilder;
import jakarta.json.JsonValue;

public class PatchOperationTest
extends CommonOperation {
    private final String OPERATION = "TEST";

    PatchOperationTest() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 test operation");
        TestUtil.logMsg((String)"Testing RFC 6902 test operation:");
        this.testOnEmptyObject(result);
        this.testOnEmptyArray(result);
        this.testOnSimpleObject(result);
        this.testOnSimpleStringArray(result);
        this.testOnSimpleIntArray(result);
        this.testOnSimpleBoolArray(result);
        this.testOnSimpleObjectArray(result);
        return result;
    }

    private void testOnEmptyObject(TestResult result) {
        TestUtil.logMsg((String)" - on empty JSON object");
        JsonObject in = SimpleValues.createEmptyObject();
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        Object[] values = new Object[]{"In a galaxy far far away", 42, true, SimpleValues.OBJ_VALUE};
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)in, paths[j], values[i]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private void testOnEmptyArray(TestResult result) {
        TestUtil.logMsg((String)" - on empty JSON array");
        JsonArray in = SimpleValues.createEmptyArray();
        String[] paths = new String[]{"/-1", "/0", "/1", "/2", "/3", "/4", "/5", "/-"};
        Object[] values = new Object[]{"In a galaxy far far away", 42, true, SimpleValues.OBJ_VALUE};
        for (int i = 0; i < values.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)in, paths[j], values[i]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private void testOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - on simple JSON object");
        JsonObject[] in = new JsonObject[]{SimpleValues.createSimpleObjectStr(), SimpleValues.createSimpleObjectInt(), SimpleValues.createSimpleObjectBool(), SimpleValues.createSimpleObjectObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        Object[] values = new Object[]{"In a galaxy far far away", 42, true, SimpleValues.OBJ_VALUE};
        for (int o = 0; o < in.length; ++o) {
            for (int i = 0; i < values.length; ++i) {
                for (int j = 0; j < paths.length; ++j) {
                    if (o == i && o == j) {
                        this.simpleOperation(result, (JsonValue)in[o], null, paths[j], values[i]);
                        continue;
                    }
                    this.simpleOperationFail(result, (JsonValue)in[o], paths[j], values[i]);
                }
            }
            this.simpleOperation(result, (JsonValue)in[o], null, "", in[o]);
        }
    }

    private void testOnSimpleStringArray(TestResult result) {
        int i;
        TestUtil.logMsg((String)" - on simple JSON String array of size 5");
        JsonArray in = SimpleValues.createSimpleStringArray5();
        String[] indexes = new String[]{"/-1", "/-", "/address"};
        String[] values = new String[]{"First value", "Second value", "Third value", "Fourth value", "Fifth value"};
        for (i = 0; i <= 5; ++i) {
            String path = PatchOperationTest.arrayPtr("/", i);
            for (int v = 0; v < values.length; ++v) {
                if (i == v) {
                    this.simpleOperation(result, (JsonValue)in, null, path, values[v]);
                    continue;
                }
                this.simpleOperationFail(result, (JsonValue)in, path, values[v]);
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            for (int v = 0; v < values.length; ++v) {
                this.simpleOperationFail(result, (JsonValue)in, indexes[i], values[v]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private void testOnSimpleIntArray(TestResult result) {
        int i;
        TestUtil.logMsg((String)" - on simple JSON int array of size 5");
        JsonArray in = SimpleValues.createSimpleIntArray5();
        String[] indexes = new String[]{"/-1", "/-", "/age"};
        int[] values = new int[]{1, 2, 3, 4, 5};
        for (i = 0; i <= 5; ++i) {
            String path = PatchOperationTest.arrayPtr("/", i);
            for (int v = 0; v < values.length; ++v) {
                if (i == v) {
                    this.simpleOperation(result, (JsonValue)in, null, path, values[v]);
                    continue;
                }
                this.simpleOperationFail(result, (JsonValue)in, path, values[v]);
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            for (int v = 0; v < values.length; ++v) {
                this.simpleOperationFail(result, (JsonValue)in, indexes[i], values[v]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private void testOnSimpleBoolArray(TestResult result) {
        int i;
        TestUtil.logMsg((String)" - on simple JSON boolean array of size 2");
        JsonArray in = SimpleValues.createBoolArray2();
        String[] indexes = new String[]{"/-1", "/-", "/married"};
        boolean[] values = new boolean[]{true, false};
        for (i = 0; i <= 2; ++i) {
            String path = PatchOperationTest.arrayPtr("/", i);
            for (int v = 0; v < values.length; ++v) {
                if (i == v) {
                    this.simpleOperation(result, (JsonValue)in, null, path, values[v]);
                    continue;
                }
                this.simpleOperationFail(result, (JsonValue)in, path, values[v]);
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            for (int v = 0; v < values.length; ++v) {
                this.simpleOperationFail(result, (JsonValue)in, indexes[i], values[v]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private void testOnSimpleObjectArray(TestResult result) {
        int i;
        TestUtil.logMsg((String)" - on simple JSON JsonObject array of size 5");
        JsonArray in = SimpleValues.createSimpleObjectArray5();
        String[] indexes = new String[]{"/-1", "/-", "/wife"};
        JsonObject[] values = new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_3, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5};
        for (i = 0; i <= 5; ++i) {
            String path = PatchOperationTest.arrayPtr("/", i);
            for (int v = 0; v < values.length; ++v) {
                if (i == v) {
                    this.simpleOperation(result, (JsonValue)in, null, path, values[v]);
                    continue;
                }
                this.simpleOperationFail(result, (JsonValue)in, path, values[v]);
            }
        }
        for (i = 0; i < indexes.length; ++i) {
            for (int v = 0; v < values.length; ++v) {
                this.simpleOperationFail(result, (JsonValue)in, indexes[i], values[v]);
            }
        }
        this.simpleOperation(result, (JsonValue)in, null, "", in);
    }

    private static String arrayPtr(String prefix, int index) {
        int prefixLen = prefix != null ? prefix.length() : 0;
        String indexStr = Integer.toString(index);
        StringBuilder sb = new StringBuilder(prefixLen + indexStr.length());
        if (prefixLen > 0) {
            sb.append(prefix);
        }
        sb.append(indexStr);
        return sb.toString();
    }

    @Override
    protected String operationName() {
        return "TEST";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        return PatchOperationTest.builderTest(Json.createPatchBuilder(), path, value);
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        return PatchOperationTest.builderTest(builder, path, value);
    }

    private static JsonPatchBuilder builderTest(JsonPatchBuilder builder, String path, Object value) {
        switch (JsonValueType.getType(value.getClass())) {
            case String: {
                return builder.test(path, (String)value);
            }
            case Integer: {
                return builder.test(path, ((Integer)value).intValue());
            }
            case Boolean: {
                return builder.test(path, ((Boolean)value).booleanValue());
            }
            case JsonValue: {
                return builder.test(path, (JsonValue)value);
            }
        }
        throw new IllegalArgumentException("Value does not match known JSON value type");
    }

    @Override
    protected boolean operationFailed(JsonValue check, JsonValue out) {
        return out == null;
    }
}

