/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.connector.whitebox;

import com.sun.ts.tests.common.connector.util.ConnectorStatus;
import com.sun.ts.tests.common.connector.whitebox.Debug;
import com.sun.ts.tests.common.connector.whitebox.SimplePrincipal;
import jakarta.resource.spi.work.SecurityContext;
import jakarta.security.auth.message.callback.CallerPrincipalCallback;
import jakarta.security.auth.message.callback.GroupPrincipalCallback;
import jakarta.security.auth.message.callback.PasswordValidationCallback;
import java.security.Principal;
import java.util.ArrayList;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class TSSecurityContext
extends SecurityContext {
    private String userName = null;
    private String password = null;
    private String eisPrincipalName = null;
    private String description = null;
    private String logOutString = null;
    private boolean translationRequired;
    private boolean useCPC = true;
    private boolean useGPC = false;
    private boolean usePVC = false;
    private boolean addPrinToExecSubject = false;
    private boolean expectFailure = false;

    public TSSecurityContext(String userName, String password, String eisPrincipalName, boolean translationRequired) {
        this.userName = userName;
        this.password = password;
        this.eisPrincipalName = eisPrincipalName;
        this.translationRequired = translationRequired;
        this.description = super.getDescription();
        this.debug("TSSecurityContext:  userName=" + userName + "  password=" + password + "  eisPrincipalName=" + eisPrincipalName + "  translationRequired=" + translationRequired);
    }

    public void setCallbacks(boolean bCPC, boolean bGPC, boolean bPVC) {
        this.useCPC = bCPC;
        this.useGPC = bGPC;
        this.usePVC = bPVC;
    }

    public void setUserName(String val) {
        this.userName = val;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setPassword(String val) {
        this.password = val;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUseCPC(boolean val) {
        this.useCPC = val;
    }

    public boolean getUseCPC() {
        return this.useCPC;
    }

    public void setUseGPC(boolean val) {
        this.useGPC = val;
    }

    public boolean getUseGPC() {
        return this.useGPC;
    }

    public void setUsePVC(boolean val) {
        this.usePVC = val;
    }

    public boolean getUsePVC() {
        return this.usePVC;
    }

    public void setAddPrinToExecSubject(boolean val) {
        this.addPrinToExecSubject = val;
    }

    public boolean getAddPrinToExecSubject() {
        return this.addPrinToExecSubject;
    }

    public void setDescription(String val) {
        this.description = val;
    }

    public String getDescription() {
        return this.description;
    }

    public void setLogOutString(String val) {
        this.logOutString = val;
    }

    public String getLogOutString() {
        return this.logOutString;
    }

    public boolean isTranslationRequired() {
        return this.translationRequired;
    }

    public void setExpectFailure(boolean val) {
        this.expectFailure = val;
    }

    public boolean getExpectFailure() {
        return this.expectFailure;
    }

    public void doCallbackVerification(CallbackHandler callbackHandler, Subject execSubject, Subject serviceSubject) {
        ArrayList<Object> callbacks = new ArrayList<Object>();
        PasswordValidationCallback pvc = null;
        GroupPrincipalCallback gpc = null;
        CallerPrincipalCallback cpc = null;
        String[] gpcGroups = new String[]{"phakegrp1", "phakegrp2"};
        this.debug("doCallbackVerification():  translationRequired = " + this.translationRequired);
        if (this.addPrinToExecSubject && this.userName != null) {
            this.debug("doCallbackVerification():  adding principal: " + this.userName + " to execSubject.");
            execSubject.getPrincipals().add(new SimplePrincipal(this.userName, this.password));
        }
        if (this.useGPC) {
            gpc = new GroupPrincipalCallback(execSubject, gpcGroups);
            this.debug("doCallbackVerification(): - GPC with groups={phakegrp1, phakegrp2}");
            callbacks.add(gpc);
        }
        if (this.usePVC && !this.translationRequired) {
            this.debug("doCallbackVerification():  initializing PVC");
            char[] pwd = null;
            if (this.password != null) {
                pwd = this.password.toCharArray();
            }
            if (this.userName != null) {
                pvc = new PasswordValidationCallback(execSubject, this.userName, pwd);
                this.debug("setting PVC with user [ " + this.userName + " ] + password [ " + this.password + " ]");
            } else {
                pvc = new PasswordValidationCallback(execSubject, "fk_usr", null);
                this.debug("setting PVC with user=fk_usr  and  password=null");
            }
            callbacks.add(pvc);
        }
        if (this.usePVC || this.useCPC) {
            if (this.translationRequired && this.eisPrincipalName != null) {
                this.debug("translationRequired, setting CPC with principal : " + this.eisPrincipalName);
                cpc = new CallerPrincipalCallback(execSubject, (Principal)new SimplePrincipal(this.eisPrincipalName));
            } else if (!this.translationRequired && this.userName != null) {
                this.debug("No translationRequired, setting CPC with userName : " + this.userName);
                cpc = new CallerPrincipalCallback(execSubject, this.userName);
            } else {
                this.debug("setting CPC with null Principal");
                cpc = new CallerPrincipalCallback(execSubject, (Principal)null);
            }
            callbacks.add(cpc);
        }
        Callback[] callbackArray = new Callback[callbacks.size()];
        try {
            callbackHandler.handle(callbacks.toArray(callbackArray));
            String sval = "";
            sval = this.logOutString != null ? this.logOutString : "setupSecurityContext callbackhandler supports required callback types.";
            ConnectorStatus.getConnectorStatus().logState(sval);
            this.debug(sval);
            if (!this.translationRequired && this.usePVC && pvc != null && !pvc.getResult()) {
                this.debug("doCallbackVerification():  PVC failed");
            } else if (!this.translationRequired && this.usePVC && pvc != null) {
                this.debug("doCallbackVerification():  PVC succeeded");
            }
        }
        catch (UnsupportedCallbackException e) {
            String sval = "";
            sval = this.expectFailure && this.logOutString != null ? "Expected Exception: " + this.logOutString : "doCallbackVerification(): callbackhandler does not support a required callback type!";
            ConnectorStatus.getConnectorStatus().logState(sval);
            this.debug(sval);
            this.debug("UnsupportedCallbackException message is : " + e.getMessage());
            e.printStackTrace();
        }
        catch (Exception e) {
            String sval = "";
            sval = this.expectFailure && this.logOutString != null ? "Expected Exception: " + this.logOutString : "doCallbackVerification(): callbackhandler threw unexpected exception!";
            ConnectorStatus.getConnectorStatus().logState(sval);
            this.debug(sval);
            e.printStackTrace();
            this.debug("doCallbackVerification():  exception occured : " + e.getMessage());
        }
    }

    public void setupSecurityContext(CallbackHandler callbackHandler, Subject execSubject, Subject serviceSubject) {
        this.validateCallbackHandler(callbackHandler);
        this.validateExecSubject(execSubject);
        this.validateServiceSubject(serviceSubject);
        this.doCallbackVerification(callbackHandler, execSubject, serviceSubject);
    }

    private void validateCallbackHandler(CallbackHandler callbackHandler) {
        String str = "";
        str = callbackHandler != null ? "setupSecurityContext() called with non-null callbackHandler" : "setupSecurityContext() called with invalid (null) callbackHandler";
        this.debug(str);
        ConnectorStatus.getConnectorStatus().logState(str);
    }

    private void validateExecSubject(Subject execSubject) {
        String str = "";
        str = execSubject != null && !execSubject.isReadOnly() ? "setupSecurityContext() called with valid executionSubject" : "ERROR:  setupSecurityContext() called with invalid executionSubject";
        this.debug(str);
        ConnectorStatus.getConnectorStatus().logState(str);
    }

    private void validateServiceSubject(Subject serviceSubject) {
        String str = "";
        if (serviceSubject == null) {
            str = "setupSecurityContext() called with valid serviceSubject";
        } else if (serviceSubject != null && !serviceSubject.isReadOnly()) {
            str = "setupSecurityContext() called with valid serviceSubject";
        } else if (serviceSubject != null && serviceSubject.isReadOnly()) {
            str = "setupSecurityContext() called with invalid executionSubject";
        }
        this.debug(str);
        ConnectorStatus.getConnectorStatus().logState(str);
    }

    public String toString() {
        StringBuffer toString = new StringBuffer("{");
        toString.append("userName : " + this.userName);
        toString.append(", password : " + this.password);
        toString.append(", eisPrincipalName : " + this.eisPrincipalName);
        toString.append(", translationRequired : " + this.translationRequired);
        toString.append("}");
        return toString.toString();
    }

    public void debug(String message) {
        Debug.trace(message);
    }
}

