/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.embeddable;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.embeddable.Address;
import com.sun.ts.tests.jpa.core.annotations.embeddable.B;
import com.sun.ts.tests.jpa.core.annotations.embeddable.ZipCode;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void EM1XMTest() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin EM1XMTest2");
        boolean pass = false;
        EntityManager em = this.getEntityManager();
        EntityTransaction et = this.getEntityTransaction();
        try {
            et.begin();
            TestUtil.logTrace((String)"New instances");
            ZipCode z1 = new ZipCode("01801", "1234");
            Address addr1 = new Address("1 Network Drive", "Burlington", "MA");
            addr1.setZipCode(z1);
            B b1 = new B("1", "b1", 1);
            b1.setAddress(addr1);
            em.persist((Object)b1);
            em.flush();
            B newB = this.findB("1");
            em.refresh((Object)newB);
            String newStreet = (String)em.createQuery("Select b.address.street from B b ").getSingleResult();
            String newState = (String)em.createQuery("Select b.address.state from B b ").getSingleResult();
            String newCity = (String)em.createQuery("Select b.address.city from B b ").getSingleResult();
            String newPlusFour = (String)em.createQuery("Select b.address.zipCode.plusFour from B b ").getSingleResult();
            String newZip = (String)em.createQuery("Select b.address.zipCode.zip from B b ").getSingleResult();
            boolean pass1 = false;
            boolean pass2 = false;
            boolean pass3 = false;
            boolean pass4 = false;
            boolean pass5 = false;
            if (addr1.getStreet().equals(newStreet)) {
                pass1 = true;
                TestUtil.logTrace((String)"Received Street match");
            }
            if (addr1.getState().equals(newState)) {
                pass2 = true;
                TestUtil.logTrace((String)"Received State match");
            }
            if (addr1.getCity().equals(newCity)) {
                pass3 = true;
                TestUtil.logTrace((String)"Received City match");
            }
            if (addr1.getZipCode().getPlusFour().equals(newPlusFour)) {
                pass4 = true;
                TestUtil.logTrace((String)"Received zipCode PlusFour match");
            }
            if (addr1.getZipCode().getZip().equals(newZip)) {
                pass5 = true;
                TestUtil.logTrace((String)"Received zipCode zip match");
            }
            if (pass1 && pass2 && pass3 && pass4 && pass5) {
                pass = true;
                TestUtil.logTrace((String)"Received Address match");
            } else {
                TestUtil.logTrace((String)"Received incorrect data");
            }
            et.commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        finally {
            try {
                if (et.isActive()) {
                    et.rollback();
                }
            }
            catch (Exception fe) {
                TestUtil.logErr((String)"Unexpected exception rolling back TX:", (Throwable)fe);
            }
        }
        if (!pass) {
            throw new EETest.Fault("EM1XMTest failed");
        }
    }

    private B findB(String id) {
        return (B)this.getEntityManager().find(B.class, (Object)id);
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from B_EMBEDDABLE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

