/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.pointertests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonException;
import jakarta.json.JsonObject;
import jakarta.json.JsonPointer;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;

public class PointerReplace {
    PointerReplace() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6901 pointer usage for RFC 6902 replace operation");
        TestUtil.logMsg((String)"Testing RFC 6901 pointer usage for RFC 6902 replace operation");
        this.testReplaceStringOnSimpleObject(result);
        this.testReplaceStringOnSimpleArray(result);
        this.testReplaceStringOnSimpleArray2(result);
        this.testReplaceIntOnSimpleObject(result);
        this.testReplaceIntOnSimpleArray(result);
        this.testReplaceIntOnSimpleArray2(result);
        this.testReplaceBoolOnSimpleObject(result);
        this.testReplaceBoolOnSimpleArray(result);
        this.testReplaceBoolOnSimpleArray2(result);
        this.testReplaceObjectOnCompoundObject(result);
        this.testReplaceObjectOnSimpleArray(result);
        this.testReplaceObjectOnSimpleArray2(result);
        this.testReplaceOfNonExistingLocationInObject(result);
        this.testReplaceOfNonExistingLocationInArray(result);
        return result;
    }

    private void testReplaceStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectReplaceStr();
        JsonPointer ptr = Json.createPointer((String)"/address");
        JsonObject out = (JsonObject)ptr.replace((JsonStructure)in, (JsonValue)Json.createValue((String)"In a land of myth"));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/address\" REPLACE \"In a land of myth\" failed on simple JSON object");
        }
    }

    private void testReplaceStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 1");
        JsonArray in = SimpleValues.createStringArray1();
        JsonArray check = SimpleValues.createSimpleStringArrayReplaceStr();
        JsonPointer ptr = Json.createPointer((String)"/0");
        JsonArray out = (JsonArray)ptr.replace((JsonStructure)in, (JsonValue)Json.createValue((String)"In a galaxy far far away"));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/0\" REPLACE \"In a galaxy far far away\" failed on simple JSON array");
        }
    }

    private void testReplaceStringOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleStringArray5();
        JsonArray check = SimpleValues.createSimpleStringArray5R();
        this.verifyReplaceValues(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new String[]{"First value", "Second value", "Fourth value", "Fifth value"}, "Pointer REPLACE operation", "Pointers \"/4\", \"/3\", \"/1\", \"/0\" REPLACE sequence failed on simple JSON array");
        this.verifyReplaceValues(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new String[]{"Fifth value", "Fourth value", "Second value", "First value"}, "Pointer REPLACE operation", "Pointers \"/0\", \"/1\", \"/3\", \"/4\" REPLACE sequence failed on simple JSON array");
    }

    private void testReplaceIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectReplaceInt();
        JsonPointer ptr = Json.createPointer((String)"/age");
        JsonObject out = (JsonObject)ptr.replace((JsonStructure)in, (JsonValue)Json.createValue((int)32));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/age\" REPLACE \"32\" failed on simple JSON object");
        }
    }

    private void testReplaceIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 1");
        JsonArray in = SimpleValues.createIntArray1();
        JsonArray check = SimpleValues.createSimpleIntArrayReplaceInt();
        JsonPointer ptr = Json.createPointer((String)"/0");
        JsonArray out = (JsonArray)ptr.replace((JsonStructure)in, (JsonValue)Json.createValue((int)42));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/0\" REPLACE \"42\" failed on simple JSON array");
        }
    }

    private void testReplaceIntOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleIntArray5();
        JsonArray check = SimpleValues.createSimpleIntArray5R();
        this.verifyReplaceValues(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new Integer[]{1, 2, 4, 5}, "Pointer REPLACE operation", "Pointers \"/4\", \"/3\", \"/1\", \"/0\" REPLACE sequence failed on simple JSON array");
        this.verifyReplaceValues(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new Integer[]{5, 4, 2, 1}, "Pointer REPLACE operation", "Pointers \"/0\", \"/1\", \"/3\", \"/4\" REPLACE sequence failed on simple JSON array");
    }

    private void testReplaceBoolOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectReplaceBool();
        JsonPointer ptr = Json.createPointer((String)"/married");
        JsonObject out = (JsonObject)ptr.replace((JsonStructure)in, SimpleValues.toJsonValue(false));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/married\" REPLACE \"false\" failed on simple JSON object");
        }
    }

    private void testReplaceBoolOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 1");
        JsonArray in = SimpleValues.createBoolArray1();
        JsonArray check = SimpleValues.createSimpleBoolArrayReplaceBool();
        JsonPointer ptr = Json.createPointer((String)"/0");
        JsonArray out = (JsonArray)ptr.replace((JsonStructure)in, SimpleValues.toJsonValue(false));
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/0\" REPLACE \"false\" failed on simple JSON array");
        }
    }

    private void testReplaceBoolOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleBoolArray5();
        JsonArray check = SimpleValues.createSimpleBoolArray5R();
        this.verifyReplaceValues(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new Boolean[]{false, true, false, true}, "Pointer REPLACE operation", "Pointers \"/4\", \"/3\", \"/1\", \"/0\" REPLACE sequence failed on simple JSON array");
        this.verifyReplaceValues(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new Boolean[]{true, false, true, false}, "Pointer REPLACE operation", "Pointers \"/0\", \"/1\", \"/3\", \"/4\" REPLACE sequence failed on simple JSON array");
    }

    private void testReplaceObjectOnCompoundObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createCompoundObjectWithObject();
        JsonObject check = SimpleValues.createCompoundObjectReplaceObject();
        JsonPointer ptr = Json.createPointer((String)"/wife");
        JsonObject out = (JsonObject)ptr.replace((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE2);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/wife\" REPLACE \"" + SimpleValues.OBJ_VALUE2 + "\" failed on simple JSON object");
        }
    }

    private void testReplaceObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 1");
        JsonArray in = SimpleValues.createObjectArray1();
        JsonArray check = SimpleValues.createSimpleObjectArrayReplaceObject();
        JsonPointer ptr = Json.createPointer((String)"/0");
        JsonArray out = (JsonArray)ptr.replace((JsonStructure)in, (JsonValue)SimpleValues.OBJ_VALUE);
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail("Pointer REPLACE operation", "Pointer \"/0\" REPLACE \"" + SimpleValues.OBJ_VALUE + "\" failed on simple JSON array");
        }
    }

    private void testReplaceObjectOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleObjectArray5();
        JsonArray check = SimpleValues.createSimpleObjectArray5R();
        this.verifyReplaceValues(result, in, check, new String[]{"/4", "/3", "/1", "/0"}, new JsonObject[]{SimpleValues.OBJ_VALUE_1, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_5}, "Pointer REPLACE operation", "Pointers \"/4\", \"/3\", \"/1\", \"/0\" REPLACE sequence failed on simple JSON array");
        this.verifyReplaceValues(result, in, check, new String[]{"/0", "/1", "/3", "/4"}, new JsonObject[]{SimpleValues.OBJ_VALUE_5, SimpleValues.OBJ_VALUE_4, SimpleValues.OBJ_VALUE_2, SimpleValues.OBJ_VALUE_1}, "Pointer REPLACE operation", "Pointers \"/0\", \"/1\", \"/3\", \"/4\" REPLACE sequence failed on simple JSON array");
    }

    private void testReplaceOfNonExistingLocationInObject(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonObject");
        JsonObject[] objsIn = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObject(), SimpleValues.createCompoundObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        JsonValue[] values = new JsonValue[]{Json.createValue((String)"In a galaxy far far away"), Json.createValue((int)42), SimpleValues.toJsonValue(true), SimpleValues.OBJ_VALUE};
        for (int i = 0; i < objsIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                JsonPointer ptr = Json.createPointer((String)paths[j]);
                try {
                    JsonObject out = (JsonObject)ptr.replace((JsonStructure)objsIn[i], values[i]);
                    result.fail("Pointer REPLACE operation", "Pointer \"" + paths[j] + "\" REPLACE succeeded on non existing location");
                    continue;
                }
                catch (JsonException jsonException) {
                    // empty catch block
                }
            }
        }
    }

    private void testReplaceOfNonExistingLocationInArray(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonArray");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray1(), SimpleValues.createIntArray2(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createObjectArray2()};
        String[] paths = new String[]{"/", "/-1", "/-", "/5", "/0a", "/42", "/address/0"};
        JsonValue[] values = new JsonValue[]{Json.createValue((String)"In a galaxy far far away"), Json.createValue((String)"In a galaxy far far away"), Json.createValue((int)42), SimpleValues.toJsonValue(true), SimpleValues.OBJ_VALUE};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                JsonPointer ptr = Json.createPointer((String)paths[j]);
                try {
                    JsonArray out = (JsonArray)ptr.replace((JsonStructure)arraysIn[i], values[i]);
                    result.fail("Pointer REPLACE operation", "Pointer \"" + paths[j] + "\" REPLACE succeeded on non existing location");
                    continue;
                }
                catch (JsonException jsonException) {
                    // empty catch block
                }
            }
        }
    }

    private void verifyReplaceValues(TestResult result, JsonArray in, JsonArray check, String[] paths, Object[] values, String testName, String errorMessage) {
        if (paths.length != values.length) {
            throw new IllegalArgumentException("Number of paths does not match number of indexes");
        }
        JsonArray out = in;
        for (int i = 0; i < paths.length; ++i) {
            JsonPointer ptr = Json.createPointer((String)paths[i]);
            out = (JsonArray)ptr.replace((JsonStructure)out, SimpleValues.toJsonValue(values[i]));
        }
        if (!JsonAssert.assertEquals((JsonValue)check, (JsonValue)out)) {
            result.fail(testName, errorMessage);
        }
    }
}

