/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.LoopBack;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.LoopBackHome;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.LoopBackLocal;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.LoopBackLocalHome;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.nonreentranttest.TestBeanLocal;
import jakarta.ejb.CreateException;
import jakarta.ejb.EJBException;
import jakarta.ejb.EntityBean;
import jakarta.ejb.EntityContext;
import jakarta.ejb.RemoveException;
import java.rmi.RemoteException;
import java.util.Properties;
import javax.naming.NamingException;

public abstract class TestBeanEJB
implements EntityBean {
    private EntityContext ectx = null;
    private TSNamingContext nctx = null;
    private static final String beanName = "java:comp/env/ejb/LoopBackBean";
    private static final String beanNameLocal = "java:comp/env/ejb/LoopBackBeanLocal";

    public abstract Integer getId();

    public abstract void setId(Integer var1);

    public abstract String getBrandName();

    public abstract void setBrandName(String var1);

    public abstract float getPrice();

    public abstract void setPrice(float var1);

    public Integer ejbCreate(Properties p, int id, String brandName, float price) throws CreateException {
        TestUtil.logTrace((String)"ejbCreate");
        Integer pk = new Integer(id);
        try {
            this.setId(pk);
            this.setBrandName(brandName);
            this.setPrice(price);
            TestUtil.logMsg((String)"Initialize remote logging");
            TestUtil.init((Properties)p);
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException(e.getMessage());
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new CreateException("Exception occurred: " + e);
        }
        return null;
    }

    public void ejbPostCreate(Properties p, int id, String brandName, float price) {
        TestUtil.logTrace((String)"ejbPostCreate");
    }

    public void setEntityContext(EntityContext c) {
        TestUtil.logTrace((String)"setEntityContext");
        this.ectx = c;
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
        }
        catch (NamingException e) {
            TestUtil.logErr((String)("NamingException ... " + e), (Throwable)e);
            throw new EJBException("unable to obtain naming context");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception ... " + e), (Throwable)e);
            throw new EJBException("Exception occurred: " + e);
        }
    }

    public void unsetEntityContext() {
        TestUtil.logTrace((String)"unsetEntityContext");
    }

    public void ejbRemove() throws RemoveException {
        TestUtil.logTrace((String)"ejbRemove");
    }

    public void ejbActivate() {
        TestUtil.logTrace((String)"ejbActivate");
    }

    public void ejbPassivate() {
        TestUtil.logTrace((String)"ejbPassivate");
    }

    public void ejbLoad() {
        TestUtil.logTrace((String)"ejbLoad");
    }

    public void ejbStore() {
        TestUtil.logTrace((String)"ejbStore");
    }

    public void ping() {
        TestUtil.logTrace((String)"ping");
    }

    public void sleep(int n) {
        long t2;
        TestUtil.logTrace((String)"sleep");
        long t1 = System.currentTimeMillis();
        while ((t2 = System.currentTimeMillis()) < t1 + (long)n) {
        }
    }

    public boolean loopBackSameBean() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBean");
        TestUtil.logMsg((String)"Perform loopback test");
        try {
            TestUtil.logMsg((String)"getEJBObject() reference");
            TestBean ref = (TestBean)this.ectx.getEJBObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logErr((String)"No exception occurred during loopback call");
            pass = false;
        }
        catch (RemoteException e) {
            TestUtil.logMsg((String)("Caught RemoteException as expected: " + e));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBean(Properties p) {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBean");
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup home interface for EJB: java:comp/env/ejb/LoopBackBean");
            LoopBackHome beanHome = (LoopBackHome)this.nctx.lookup(beanName, LoopBackHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            LoopBack beanRef = beanHome.create();
            TestUtil.logMsg((String)"Initialize remote logging");
            beanRef.initLogging(p);
            TestUtil.logMsg((String)"Set bean reference");
            beanRef.setBeanRef((TestBean)this.ectx.getEJBObject());
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = beanRef.loopBackTest();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackSameBeanLocal() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackSameBeanLocal");
        TestUtil.logMsg((String)"Perform loopback test - local");
        try {
            TestUtil.logMsg((String)"getEJBLocalObject() reference");
            TestBeanLocal ref = (TestBeanLocal)this.ectx.getEJBLocalObject();
            TestUtil.logMsg((String)"Performing self-referential loopback call test");
            ref.ping();
            TestUtil.logErr((String)"No exception occurred during loopback call");
            pass = false;
        }
        catch (EJBException e) {
            TestUtil.logMsg((String)("Caught EJBException as expected: " + (Object)((Object)e)));
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught unexpected Exception: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }

    public boolean loopBackAnotherBeanLocal() {
        boolean pass;
        TestUtil.logTrace((String)"loopBackAnotherBeanLocal");
        try {
            TestUtil.logMsg((String)"Obtain naming context");
            this.nctx = new TSNamingContext();
            TestUtil.logMsg((String)"Lookup home interface for EJB: java:comp/env/ejb/LoopBackBeanLocal");
            LoopBackLocalHome beanHomeLocal = (LoopBackLocalHome)this.nctx.lookup(beanNameLocal, LoopBackLocalHome.class);
            TestUtil.logMsg((String)"Create EJB instance");
            LoopBackLocal beanRef = beanHomeLocal.create();
            TestUtil.logMsg((String)"Set bean reference");
            beanRef.setBeanRefLocal((TestBeanLocal)this.ectx.getEJBLocalObject());
            TestUtil.logMsg((String)"Performing loopback call test");
            pass = beanRef.loopBackTestLocal();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        return pass;
    }
}

