/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.module.servlet;

import com.sun.ts.tests.jaspic.tssv.module.servlet.TSRequestWrapper;
import com.sun.ts.tests.jaspic.tssv.module.servlet.TSResponseWrapper;
import com.sun.ts.tests.jaspic.tssv.util.ServerCallbackSupport;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.AuthStatus;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.MessagePolicy;
import jakarta.security.auth.message.module.ServerAuthModule;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSServletWrapperSAM
implements ServerAuthModule {
    private TSLogger logger = null;
    private static MessagePolicy requestPolicy = null;
    private static MessagePolicy responsePolicy = null;
    private static CallbackHandler callbackHandler = null;
    private static Map options = null;
    private CallbackHandler handler;
    private Class<?>[] supportedMessageTypes = new Class[]{HttpServletRequest.class, HttpServletResponse.class};

    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        this.doServerCallbackChecks(messageInfo, clientSubject, serviceSubject);
        TSRequestWrapper tswrap = new TSRequestWrapper((HttpServletRequest)messageInfo.getRequestMessage());
        tswrap.setOptionsMap(messageInfo.getMap());
        messageInfo.setRequestMessage((Object)tswrap);
        messageInfo.setResponseMessage((Object)new TSResponseWrapper((HttpServletResponse)messageInfo.getResponseMessage()));
        return AuthStatus.SUCCESS;
    }

    public Class<?>[] getSupportedMessageTypes() {
        return this.supportedMessageTypes;
    }

    public AuthStatus secureResponse(MessageInfo messageInfo, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        if (request instanceof TSRequestWrapper) {
            messageInfo.setRequestMessage((Object)((TSRequestWrapper)request).getRequest());
        } else {
            this.logMsg("Incorrect request type : " + request.getClass().getName());
        }
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        if (response instanceof TSResponseWrapper) {
            messageInfo.setResponseMessage((Object)((TSResponseWrapper)response).getResponse());
        } else {
            this.logMsg("Incorrect response type : " + response.getClass().getName());
        }
        return AuthStatus.SEND_SUCCESS;
    }

    public TSServletWrapperSAM() {
        this.logger = TSLogger.getTSLogger("jsr196");
        this.logMsg("TSServletWrapperSAM() constructor called");
    }

    public TSServletWrapperSAM(TSLogger log) {
        this.logger = log != null ? log : TSLogger.getTSLogger("jsr196");
        this.logMsg("TSServletWrapperSAM(TSLogger) constructor called");
    }

    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        if (options != null && options.get("TSLogger") != null) {
            this.logger = (TSLogger)options.get("TSLogger");
        }
        TSServletWrapperSAM.requestPolicy = requestPolicy;
        TSServletWrapperSAM.responsePolicy = responsePolicy;
        callbackHandler = handler;
        TSServletWrapperSAM.options = options;
        this.verifyRequestPolicy(requestPolicy);
        this.logger.log(Level.INFO, "CBH for HttpServlet supports type: " + handler.getClass().getName());
    }

    private void verifyRequestPolicy(MessagePolicy requestPolicy) {
        String errStr = "Layer=HttpServlet";
        errStr = errStr + " requestPolicy=invalid in TSServletWrapperSAM.initialize()";
        if (requestPolicy == null) {
            this.logger.log(Level.SEVERE, errStr);
        } else {
            MessagePolicy.TargetPolicy[] tp = requestPolicy.getTargetPolicies();
            if (tp.length < 1) {
                this.logger.log(Level.INFO, errStr);
            } else {
                for (int ii = 0; ii < tp.length; ++ii) {
                    MessagePolicy.ProtectionPolicy pp = tp[ii].getProtectionPolicy();
                    if (pp == null || this.isProtectionPolicyIDValid(pp.getID())) continue;
                    String str = "Layer=HttpServlet";
                    str = str + " Invalid ProtectionPolicy.getID()";
                    this.logger.log(Level.INFO, str);
                }
            }
        }
    }

    public boolean isProtectionPolicyIDValid(String strId) {
        boolean bval = false;
        if (strId.equals("#authenticateContent") || strId.equals("#authenticateSender")) {
            bval = true;
        }
        return bval;
    }

    private String getRequestURI(MessageInfo messageInfo) {
        String requestURI = null;
        Object reqObj = messageInfo.getRequestMessage();
        if (reqObj != null && reqObj instanceof HttpServletRequest) {
            requestURI = ((HttpServletRequest)reqObj).getRequestURI();
        }
        return requestURI;
    }

    private void logMessageTypes(MessageInfo messageInfo, String methodName) {
        String requestURI = "";
        if (messageInfo != null) {
            Object respObj;
            String msg;
            Object reqObj = messageInfo.getRequestMessage();
            if (reqObj != null) {
                msg = methodName + ": MessageInfo.getRequestMessage() is of type ";
                if (reqObj instanceof HttpServletRequest) {
                    msg = msg + "jakarta.servlet.http.HttpServletRequest";
                    requestURI = ((HttpServletRequest)reqObj).getRequestURI();
                    if (requestURI != null) {
                        String msg2 = msg + " for requestURI=" + requestURI;
                        this.logMsg(msg2);
                    }
                } else {
                    msg = msg + messageInfo.getClass().getName();
                }
                this.logMsg(msg);
            }
            if ((respObj = messageInfo.getResponseMessage()) != null) {
                msg = methodName + ": MessageInfo.getResponseMessage() is of type ";
                msg = respObj instanceof HttpServletResponse ? msg + "jakarta.servlet.http.HttpServletResponse" : msg + messageInfo.getClass().getName();
                this.logMsg(msg);
            }
        } else {
            String msg = "TSServletWrapperSAM." + methodName + " called with null MessageInfo object.";
            this.logMsg(msg);
        }
    }

    public void cleanSubject(MessageInfo messageInfo, Subject subject) throws AuthException {
        this.logMsg("TSServletWrapperSAM.cleanSubject called");
        subject = null;
    }

    public void logMsg(String str) {
        if (this.logger != null) {
            this.logger.log(Level.INFO, str);
        } else {
            System.out.println("*** TSLogger Not Initialized properly ***");
            System.out.println("*** TSSVLogMessage : ***" + str);
        }
    }

    public String getPrincipalNameFromSubject(Subject sub) {
        Principal principal2 = null;
        String concatPrincipalName = "";
        Set<Principal> principalSet = sub.getPrincipals();
        for (Principal principal2 : principalSet) {
            concatPrincipalName = concatPrincipalName + principal2.getName();
        }
        return concatPrincipalName;
    }

    private void doServerCallbackChecks(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        String servletPath = request.getContextPath() + request.getServletPath();
        String msg = "";
        ServerCallbackSupport serverCallbacks = new ServerCallbackSupport(this.logger, callbackHandler, "HttpServlet", messageInfo, clientSubject, serviceSubject);
        msg = serverCallbacks.verifyCPCCallback() ? "TSServletWrapperSAM.validateRequest(): verifyCPCCallback returned true" : "TSServletWrapperSAM.validateRequest(): verifyCPCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
        msg = serverCallbacks.verifyGPCCallback() ? "TSServletWrapperSAM.validateRequest(): verifyGPCCallback returned true" : "TSServletWrapperSAM.validateRequest(): verifyGPCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
        msg = serverCallbacks.verifyPVCCallback() ? "TSServletWrapperSAM.validateRequest(): verifyPVCCallback returned true" : "TSServletWrapperSAM.validateRequest(): verifyPVCCallback returned false";
        msg = msg + " for servletPath = " + servletPath;
        this.logMsg(msg);
    }
}

