/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSServerAuthConfig;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.MessageInfo;
import jakarta.xml.soap.MimeHeaders;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.SOAPBody;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPEnvelope;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPMessage;
import jakarta.xml.soap.SOAPPart;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.security.auth.callback.CallbackHandler;

public class SOAPTSServerAuthConfig
extends TSServerAuthConfig {
    protected SOAPTSServerAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props) {
        super(layer, applicationCtxt, cbkHandler, props);
    }

    public SOAPTSServerAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props, TSLogger tsLogger) {
        super(layer, applicationCtxt, cbkHandler, props);
        if (tsLogger != null) {
            logger = tsLogger;
        }
        String str = "TSServerAuthConfig called for layer=" + layer + " : appContext=" + applicationCtxt;
        logger.log(Level.INFO, str);
    }

    @Override
    public String getAuthContextID(MessageInfo messageInfo) {
        logger.log(Level.INFO, "getAuthContextID called");
        String rval = null;
        if (messageLayer.equals("SOAP")) {
            rval = this.getOpName((SOAPMessage)messageInfo.getRequestMessage());
            String logMsg = "getAuthContextID() called for layer=" + messageLayer;
            logMsg = logMsg + " shows AuthContextId=" + rval;
            logger.log(Level.INFO, logMsg);
        } else if (messageLayer.equals("HttpServlet")) {
            super.getAuthContextID(messageInfo);
        } else {
            rval = null;
        }
        return rval;
    }

    private String getOpName(SOAPMessage message) {
        Name name;
        String[] actions;
        if (message == null) {
            return null;
        }
        String rvalue = null;
        MimeHeaders headers = message.getMimeHeaders();
        if (headers != null && (actions = headers.getHeader("SOAPAction")) != null && actions.length > 0 && (rvalue = actions[0]) != null && rvalue.equals("\"\"")) {
            rvalue = null;
        }
        if (rvalue == null && (name = this.getName(message)) != null) {
            rvalue = name.getLocalName();
        }
        return rvalue;
    }

    private Name getName(SOAPMessage message) {
        Name rvalue;
        block4: {
            rvalue = null;
            SOAPPart soap = message.getSOAPPart();
            if (soap != null) {
                try {
                    SOAPBody body;
                    SOAPEnvelope envelope = soap.getEnvelope();
                    if (envelope == null || (body = envelope.getBody()) == null) break block4;
                    Iterator it = body.getChildElements();
                    while (it.hasNext()) {
                        Object o = it.next();
                        if (!(o instanceof SOAPElement)) continue;
                        rvalue = ((SOAPElement)o).getElementName();
                        break;
                    }
                }
                catch (SOAPException se) {
                    if (!logger.isLoggable(Level.FINE)) break block4;
                    logger.log(Level.FINE, "WSS: Unable to get SOAP envelope", se);
                }
            }
        }
        return rvalue;
    }
}

