/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.interceptorcontext;

import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.ContextOperation;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.InputStreamReaderProvider;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.ReaderClient;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.interceptorcontext.ReaderInterceptorOne;
import ee.jakarta.tck.ws.rs.api.rs.ext.interceptor.reader.interceptorcontext.ReaderInterceptorTwo;
import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.common.util.JaxrsUtil;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;

public class JAXRSClientIT
extends ReaderClient<ContextOperation> {
    private static final long serialVersionUID = -8828149277776372718L;

    public JAXRSClientIT() {
        this.setup();
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void getAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = ContextOperation.class.getAnnotations();
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETANNOTATIONS);
        Response fake = builder.entity((Object)"Entity", annotations).build();
        this.addProviders(fake);
        for (Annotation a : annotations) {
            this.setProperty(JAXRSCommonClient.Property.UNEXPECTED_RESPONSE_MATCH, a.annotationType().getName());
        }
        this.invoke();
    }

    @Test
    public void getGenericTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETGENERICTYPE);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke();
    }

    @Test
    public void getMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETMEDIATYPE);
        Response fake = builder.type(MediaType.APPLICATION_JSON_TYPE).build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/json");
        this.invoke();
    }

    @Test
    public void getPropertyIsNullTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETPROPERTY);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void getPropertyNamesTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETPROPERTYNAMES);
        Response fake = builder.build();
        this.addProviders(fake);
        for (int i = 0; i != 5; ++i) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "Property" + i);
        }
        this.invoke();
    }

    @Test
    public void getPropertyNamesIsReadOnlyTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETPROPERTYNAMESISREADONLY);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void getTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.GETTYPE);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, String.class.getName());
        this.invoke();
    }

    @Test
    public void removePropertyTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.REMOVEPROPERTY);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void setAnnotationsTest() throws JAXRSCommonClient.Fault {
        Annotation[] annotations = ReaderInterceptorOne.class.getAnnotations();
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETANNOTATIONS);
        Response fake = builder.build();
        this.addProviders(fake);
        for (Annotation a : annotations) {
            this.setProperty(JAXRSCommonClient.Property.UNORDERED_SEARCH_STRING, a.annotationType().getName());
        }
        this.invoke();
    }

    @Test
    public void setAnnotationsNullThrowsNPETest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETANNOTATIONSNULL);
        Response fake = builder.entity((Object)"Entity").build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "NullPointerException has been thrown as expected");
        this.invoke();
    }

    @Test
    public void setGenericTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETGENERICTYPE);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "[B");
        this.invoke();
    }

    @Test
    public void setMediaTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETMEDIATYPE);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "application/x-www-form-urlencoded");
        this.invoke();
    }

    @Test
    public void setPropertyTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETPROPERTY);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "Other Entity");
        this.invoke();
    }

    @Test
    public void setPropertyNullTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETPROPERTYNULL);
        Response fake = builder.build();
        this.addProviders(fake);
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "None");
        this.invoke();
    }

    @Test
    public void setTypeTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.SETTYPE);
        ByteArrayInputStream bais = new ByteArrayInputStream("Entity".getBytes());
        InputStreamReader reader = new InputStreamReader(bais);
        Response fake = builder.entity((Object)reader).build();
        this.addProviders(fake);
        this.addProvider(InputStreamReaderProvider.class);
        this.invoke();
        InputStreamReader isr = this.getResponseBody(InputStreamReader.class);
        try {
            String entity = JaxrsUtil.readFromReader(isr);
            Assertions.assertTrue((boolean)entity.contains(InputStreamReader.class.getName()), (String)("Expected " + InputStreamReader.class.getName() + " not found"));
            JAXRSClientIT.logMsg("#setType set correct type", entity);
        }
        catch (IOException e) {
            throw new JAXRSCommonClient.Fault(e);
        }
    }

    @Test
    public void ioExceptionTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.IOEXCEPTION);
        Response fake = builder.build();
        this.addProviders(fake);
        this.invoke();
        try {
            this.getResponseBody();
        }
        catch (Exception e) {
            JAXRSClientIT.assertNotNull(e.getMessage(), "Returned unexpected exception", e);
            IOException io = JAXRSClientIT.assertCause(e, IOException.class, "Unexpected exception has been found:", e);
            JAXRSClientIT.assertContains(io.getMessage(), "IOException has been thrown as expected", new Object[]{"Found unexpected message from IOException", e.getMessage()});
            JAXRSClientIT.logMsg("found expected IOException", io);
            return;
        }
        JAXRSClientIT.fault("Expected IOException not found");
    }

    @Test
    public void webApplicationExceptionTest() throws JAXRSCommonClient.Fault {
        Response.ResponseBuilder builder = this.createResponse(ContextOperation.WEBAPPLICATIONEXCEPTION);
        Response fake = builder.build();
        this.addProviders(fake);
        this.invoke();
        try {
            this.getResponseBody();
        }
        catch (Exception e) {
            WebApplicationException we = JAXRSClientIT.assertCause(e, WebApplicationException.class, "Found unexpected exception", e);
            JAXRSClientIT.assertNotNull(we.getResponse(), "WebApplicationException.getResponse is null");
            Response response = we.getResponse();
            String entity = response.getEntity().toString();
            JAXRSClientIT.assertEqualsInt(Response.Status.CONFLICT.getStatusCode(), response.getStatus(), "Unexcpected status returned from WebApplicationException.getResponse", response.getStatus());
            JAXRSClientIT.assertEquals("Other Entity", entity, "Found unexpected body content from WebApplicationException.getResponse", entity);
            JAXRSClientIT.logMsg(new Object[]{"found expected WebApplicationException", we});
            return;
        }
        JAXRSClientIT.fault("Expected WebApplicationException not found");
    }

    @Override
    protected void addProviders(Response response) throws JAXRSCommonClient.Fault {
        super.addProviders(response);
        this.addProvider(ReaderInterceptorTwo.class);
        this.addProvider(new ReaderInterceptorOne());
    }
}

