/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.classfilewriter.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.classfilewriter.util.LazySize;

public class ByteArrayDataOutputStream
extends DataOutputStream {
    private final ByteArrayOutputStream bytes;
    private final List<LazySizeImpl> sizes = new ArrayList<LazySizeImpl>();

    public ByteArrayDataOutputStream(ByteArrayOutputStream bytes) {
        super(bytes);
        this.bytes = bytes;
    }

    public ByteArrayDataOutputStream() {
        this(new ByteArrayOutputStream());
    }

    public LazySize writeSize() throws IOException {
        LazySizeImpl sv = new LazySizeImpl(this.written);
        this.sizes.add(sv);
        this.writeInt(0);
        return sv;
    }

    public byte[] getBytes() {
        byte[] data = this.bytes.toByteArray();
        for (LazySizeImpl i : this.sizes) {
            this.overwriteInt(data, i.position, i.value);
        }
        return data;
    }

    private void overwriteInt(byte[] bytecode, int offset, int value) {
        bytecode[offset] = (byte)(value >> 24);
        bytecode[offset + 1] = (byte)(value >> 16);
        bytecode[offset + 2] = (byte)(value >> 8);
        bytecode[offset + 3] = (byte)value;
    }

    private class LazySizeImpl
    implements LazySize {
        private final int position;
        private int value;

        public LazySizeImpl(int position) {
            this.position = position;
        }

        @Override
        public void markEnd() {
            this.value = ByteArrayDataOutputStream.this.written - this.position - 4;
        }
    }
}

