/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.http2.frames;

import java.util.Collections;
import java.util.Map;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.ThreadCache;
import org.glassfish.grizzly.http2.frames.ErrorCode;
import org.glassfish.grizzly.http2.frames.Http2Frame;
import org.glassfish.grizzly.memory.MemoryManager;

public class RstStreamFrame
extends Http2Frame {
    private static final ThreadCache.CachedTypeIndex<RstStreamFrame> CACHE_IDX = ThreadCache.obtainIndex(RstStreamFrame.class, 8);
    public static final int TYPE = 3;
    private ErrorCode errorCode;

    private RstStreamFrame() {
    }

    static RstStreamFrame create() {
        RstStreamFrame frame = ThreadCache.takeFromCache(CACHE_IDX);
        if (frame == null) {
            frame = new RstStreamFrame();
        }
        return frame;
    }

    public static Http2Frame fromBuffer(int flags, int streamId, Buffer frameBuffer) {
        RstStreamFrame frame = RstStreamFrame.create();
        frame.setFlags(flags);
        frame.setStreamId(streamId);
        frame.setFrameBuffer(frameBuffer);
        frame.errorCode = ErrorCode.lookup(frameBuffer.getInt());
        return frame;
    }

    public static RstStreamFrameBuilder builder() {
        return new RstStreamFrameBuilder();
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RstStreamFrame {").append(this.headerToString()).append(", errorCode=").append((Object)this.errorCode).append('}');
        return sb.toString();
    }

    @Override
    protected int calcLength() {
        return 4;
    }

    @Override
    protected Map<Integer, String> getFlagNamesMap() {
        return Collections.emptyMap();
    }

    @Override
    public void recycle() {
        if (DONT_RECYCLE) {
            return;
        }
        this.errorCode = null;
        super.recycle();
        ThreadCache.putToCache(CACHE_IDX, this);
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public Buffer toBuffer(MemoryManager memoryManager) {
        Object buffer = memoryManager.allocate(13);
        this.serializeFrameHeader((Buffer)buffer);
        buffer.putInt(this.errorCode.getCode());
        buffer.trim();
        return buffer;
    }

    public static class RstStreamFrameBuilder
    extends Http2Frame.Http2FrameBuilder<RstStreamFrameBuilder> {
        private ErrorCode errorCode;

        protected RstStreamFrameBuilder() {
        }

        public RstStreamFrameBuilder errorCode(ErrorCode errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public RstStreamFrame build() {
            RstStreamFrame frame = RstStreamFrame.create();
            this.setHeaderValuesTo(frame);
            frame.errorCode = this.errorCode;
            return frame;
        }

        @Override
        protected RstStreamFrameBuilder getThis() {
            return this;
        }
    }
}

