/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import com.sun.messaging.jms.MQInvalidDestinationRuntimeException;
import com.sun.messaging.jms.MQMessageFormatRuntimeException;
import com.sun.messaging.jms.MQMessageNotWriteableRuntimeException;
import com.sun.messaging.jms.MQRuntimeException;
import jakarta.jms.BytesMessage;
import jakarta.jms.CompletionListener;
import jakarta.jms.Destination;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.TextMessage;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class JMSProducerImpl
implements JMSProducer,
Traceable {
    JMSContextImpl contextImpl;
    boolean disableMessageID = false;
    boolean disableMessageTimestamp = false;
    int deliveryMode = 2;
    int priority = 4;
    long timeToLive = 0L;
    long deliveryDelay = 0L;
    String jmsCorrelationID = null;
    byte[] jmsCorrelationIDAsBytes = null;
    String jmsType = null;
    Destination jmsReplyTo = null;
    Hashtable<String, Object> properties = new Hashtable();
    private CompletionListener completionListener = null;

    public JMSProducerImpl(JMSContextImpl contextImpl) {
        this.contextImpl = contextImpl;
    }

    @Override
    public void dump(PrintStream ps) {
        ps.println("------ JMSProducerImpl dump start ------");
        ps.println("deliveryMode=" + this.deliveryMode);
        ps.println("priority=" + this.priority);
        ps.println("timeToLive=" + this.timeToLive);
        ps.println("deliveryDelay=" + this.deliveryDelay);
        ps.println("disableMessageID=" + this.disableMessageID);
        ps.println("disableMessageTimestamp=" + this.disableMessageTimestamp);
        ps.println("------ JMSProducerImpl dump end ------");
    }

    public JMSProducer send(Destination destination, Message message) {
        this.contextImpl.checkNotClosed();
        this.checkMessage(message);
        this.configureMessageProducer();
        this.configureMessage(message);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, message);
            } else {
                this.contextImpl.getMessageProducer().send(destination, message, this.completionListener);
            }
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, String payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        TextMessage textMessage = payload == null ? this.contextImpl.createTextMessage() : this.contextImpl.createTextMessage(payload);
        this.configureMessage((Message)textMessage);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, (Message)textMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, (Message)textMessage, this.completionListener);
            }
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Map<String, Object> payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        MapMessage mapMessage = this.contextImpl.createMapMessage();
        this.configureMessage((Message)mapMessage);
        if (payload != null) {
            try {
                for (Map.Entry<String, Object> thisEntry : payload.entrySet()) {
                    mapMessage.setObject(thisEntry.getKey(), thisEntry.getValue());
                }
            }
            catch (MessageNotWriteableException e) {
                throw new MQMessageNotWriteableRuntimeException(e);
            }
            catch (MessageFormatException e) {
                throw new MQMessageFormatRuntimeException(e);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, (Message)mapMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, (Message)mapMessage, this.completionListener);
            }
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, byte[] payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        BytesMessage bytesMessage = this.contextImpl.createBytesMessage();
        this.configureMessage((Message)bytesMessage);
        if (payload != null) {
            try {
                bytesMessage.writeBytes(payload);
            }
            catch (MessageNotWriteableException e) {
                throw new MQMessageNotWriteableRuntimeException(e);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, (Message)bytesMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, (Message)bytesMessage, this.completionListener);
            }
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        return this;
    }

    public JMSProducer send(Destination destination, Serializable payload) {
        this.contextImpl.checkNotClosed();
        this.configureMessageProducer();
        ObjectMessage objectMessage = this.contextImpl.createObjectMessage(payload);
        this.configureMessage((Message)objectMessage);
        try {
            if (this.completionListener == null) {
                this.contextImpl.getMessageProducer().send(destination, (Message)objectMessage);
            } else {
                this.contextImpl.getMessageProducer().send(destination, (Message)objectMessage, this.completionListener);
            }
        }
        catch (InvalidDestinationException e) {
            throw new MQInvalidDestinationRuntimeException(e);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        return this;
    }

    private void configureMessageProducer() {
        MessageProducer messageProducer = this.contextImpl.getMessageProducer();
        try {
            messageProducer.setPriority(this.priority);
            messageProducer.setDeliveryDelay(this.deliveryDelay);
            messageProducer.setDeliveryMode(this.deliveryMode);
            messageProducer.setTimeToLive(this.timeToLive);
            messageProducer.setDisableMessageID(this.disableMessageID);
            messageProducer.setDisableMessageTimestamp(this.disableMessageTimestamp);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
    }

    private void checkMessage(Message message) {
        if (message == null) {
            String errorString = AdministeredObject.cr.getKString("C4310");
            throw new MessageFormatRuntimeException(errorString, "C4310");
        }
    }

    private void configureMessage(Message message) {
        if (this.jmsCorrelationID != null) {
            try {
                message.setJMSCorrelationID(this.jmsCorrelationID);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        if (this.jmsCorrelationIDAsBytes != null) {
            try {
                message.setJMSCorrelationIDAsBytes(this.jmsCorrelationIDAsBytes);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        if (this.jmsType != null) {
            try {
                message.setJMSType(this.jmsType);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        if (this.jmsReplyTo != null) {
            try {
                message.setJMSReplyTo(this.jmsReplyTo);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
        for (Map.Entry<String, Object> thisEntry : this.properties.entrySet()) {
            try {
                message.setObjectProperty(thisEntry.getKey(), thisEntry.getValue());
            }
            catch (MessageNotWriteableException e) {
                throw new MQMessageNotWriteableRuntimeException(e);
            }
            catch (MessageFormatException e) {
                throw new MQMessageFormatRuntimeException(e);
            }
            catch (JMSException e) {
                throw new MQRuntimeException(e);
            }
        }
    }

    public JMSProducer setDisableMessageID(boolean disableMessageID) {
        this.contextImpl.checkNotClosed();
        this.disableMessageID = disableMessageID;
        return this;
    }

    public boolean getDisableMessageID() {
        this.contextImpl.checkNotClosed();
        return this.disableMessageID;
    }

    public JMSProducer setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.contextImpl.checkNotClosed();
        this.disableMessageTimestamp = disableMessageTimestamp;
        return this;
    }

    public boolean getDisableMessageTimestamp() {
        this.contextImpl.checkNotClosed();
        return this.disableMessageTimestamp;
    }

    public JMSProducer setDeliveryMode(int deliveryMode) {
        this.contextImpl.checkNotClosed();
        if (deliveryMode != 1 && deliveryMode != 2) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryMode", String.valueOf(deliveryMode));
            MQRuntimeException jmsre = new MQRuntimeException(errorString, "C4051");
            ExceptionHandler.throwJMSRuntimeException(jmsre);
        }
        this.deliveryMode = deliveryMode;
        return this;
    }

    public int getDeliveryMode() {
        this.contextImpl.checkNotClosed();
        return this.deliveryMode;
    }

    public JMSProducer setPriority(int priority) {
        this.contextImpl.checkNotClosed();
        if (priority < 0 || priority > 9) {
            String errorString = AdministeredObject.cr.getKString("C4051", "DeliveryPriority", String.valueOf(priority));
            MQRuntimeException jmsre = new MQRuntimeException(errorString, "C4051");
            ExceptionHandler.throwJMSRuntimeException(jmsre);
        }
        this.priority = priority;
        return this;
    }

    public int getPriority() {
        this.contextImpl.checkNotClosed();
        return this.priority;
    }

    public JMSProducer setTimeToLive(long timeToLive) {
        this.contextImpl.checkNotClosed();
        this.timeToLive = timeToLive;
        return this;
    }

    public long getTimeToLive() {
        this.contextImpl.checkNotClosed();
        return this.timeToLive;
    }

    public JMSProducer setDeliveryDelay(long deliveryDelay) {
        this.contextImpl.checkNotClosed();
        this.deliveryDelay = deliveryDelay;
        return this;
    }

    public long getDeliveryDelay() {
        this.contextImpl.checkNotClosed();
        return this.deliveryDelay;
    }

    public JMSProducer setAsync(CompletionListener completionListener) {
        if (this.contextImpl.getContainerType() == ContainerType.JavaEE_Web_or_EJB) {
            String errorString = AdministeredObject.cr.getKString("C4306");
            MQRuntimeException jmsre = new MQRuntimeException(errorString, "C4306");
            ExceptionHandler.throwJMSRuntimeException(jmsre);
        }
        this.contextImpl.checkNotClosed();
        this.completionListener = completionListener;
        return this;
    }

    public CompletionListener getAsync() {
        this.contextImpl.checkNotClosed();
        return this.completionListener;
    }

    public JMSProducer setProperty(String name, boolean value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    private void checkAndSetProperty(String name, Object value) {
        MessageImpl.checkPropertyNameSet(name);
        try {
            MessageImpl.checkValidPropertyValue(name, value);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        try {
            MessageImpl.checkValidPropertyName(name);
        }
        catch (JMSException e) {
            throw new MQRuntimeException(e);
        }
        this.properties.put(name, value);
    }

    public JMSProducer setProperty(String name, byte value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, short value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, int value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, long value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, float value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, Float.valueOf(value));
        return this;
    }

    public JMSProducer setProperty(String name, double value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, String value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer setProperty(String name, Object value) {
        this.contextImpl.checkNotClosed();
        this.checkAndSetProperty(name, value);
        return this;
    }

    public JMSProducer clearProperties() {
        this.contextImpl.checkNotClosed();
        this.properties.clear();
        return this;
    }

    public boolean propertyExists(String name) {
        this.contextImpl.checkNotClosed();
        MessageImpl.checkPropertyNameSet(name);
        return this.properties.containsKey(name);
    }

    public boolean getBooleanProperty(String name) {
        this.contextImpl.checkNotClosed();
        MessageImpl.checkPropertyNameSet(name);
        try {
            return ValueConvert.toBoolean(this.properties.get(name));
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public byte getByteProperty(String name) {
        this.contextImpl.checkNotClosed();
        MessageImpl.checkPropertyNameSet(name);
        try {
            return ValueConvert.toByte(this.properties.get(name));
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public short getShortProperty(String name) {
        this.contextImpl.checkNotClosed();
        MessageImpl.checkPropertyNameSet(name);
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toShort(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public int getIntProperty(String name) {
        this.contextImpl.checkNotClosed();
        MessageImpl.checkPropertyNameSet(name);
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toInt(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public long getLongProperty(String name) {
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toLong(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public float getFloatProperty(String name) {
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toFloat(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public double getDoubleProperty(String name) {
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toDouble(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public String getStringProperty(String name) {
        Object obj = this.properties.get(name);
        try {
            return ValueConvert.toString(obj);
        }
        catch (MessageFormatException e) {
            throw new MQMessageFormatRuntimeException(e);
        }
    }

    public Object getObjectProperty(String name) {
        this.contextImpl.checkNotClosed();
        Object obj = this.properties.get(name);
        return obj;
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public JMSProducer setJMSCorrelationIDAsBytes(byte[] correlationID) {
        this.contextImpl.checkNotClosed();
        this.jmsCorrelationIDAsBytes = correlationID;
        this.jmsCorrelationID = null;
        return this;
    }

    public byte[] getJMSCorrelationIDAsBytes() {
        this.contextImpl.checkNotClosed();
        return this.jmsCorrelationIDAsBytes;
    }

    public JMSProducer setJMSCorrelationID(String correlationID) {
        this.contextImpl.checkNotClosed();
        this.jmsCorrelationID = correlationID;
        this.jmsCorrelationIDAsBytes = null;
        return this;
    }

    public String getJMSCorrelationID() {
        this.contextImpl.checkNotClosed();
        return this.jmsCorrelationID;
    }

    public JMSProducer setJMSType(String type) {
        this.contextImpl.checkNotClosed();
        this.jmsType = type;
        return this;
    }

    public String getJMSType() {
        this.contextImpl.checkNotClosed();
        return this.jmsType;
    }

    public JMSProducer setJMSReplyTo(Destination replyTo) {
        this.contextImpl.checkNotClosed();
        this.jmsReplyTo = replyTo;
        return this;
    }

    public Destination getJMSReplyTo() {
        this.contextImpl.checkNotClosed();
        return this.jmsReplyTo;
    }
}

