/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.wss.core;

import com.sun.xml.wss.XWSSecurityException;
import com.sun.xml.wss.core.SecurityHeaderBlock;
import com.sun.xml.wss.impl.XMLUtil;
import com.sun.xml.wss.impl.misc.SecurityHeaderBlockImpl;
import jakarta.xml.soap.Name;
import jakarta.xml.soap.Node;
import jakarta.xml.soap.SOAPElement;
import jakarta.xml.soap.SOAPException;
import jakarta.xml.soap.SOAPFactory;
import java.util.Iterator;
import org.w3c.dom.Attr;

public class SignatureConfirmationHeaderBlock
extends SecurityHeaderBlockImpl {
    private String signatureValue = null;
    private String wsuId = null;

    public SignatureConfirmationHeaderBlock(String wsuId, String signatureValue) {
        this.wsuId = wsuId;
        this.signatureValue = signatureValue;
    }

    public SignatureConfirmationHeaderBlock(SOAPElement element) throws XWSSecurityException {
        if (!"SignatureConfirmation".equals(element.getLocalName()) || !XMLUtil.inWsse11NS(element)) {
            throw new XWSSecurityException("Invalid SignatureConfirmation Header Block passed");
        }
        this.setSOAPElement(element);
        String wsuId = this.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        if (!"".equals(wsuId)) {
            this.setId(wsuId);
        }
        String signatureValue = this.getAttribute("Value");
        try {
            if (!"".equals(signatureValue)) {
                this.setSignatureValue(signatureValue);
            }
        }
        catch (Exception ex) {
            throw new XWSSecurityException(ex);
        }
        Iterator<Node> children = this.getChildElements();
        org.w3c.dom.Node object = null;
        while (children.hasNext()) {
            Attr attr;
            object = (org.w3c.dom.Node)children.next();
            if (object.getNodeType() == 1) {
                throw new XWSSecurityException("Child Element Nodes not allowed inside SignatureConfirmation");
            }
            if (object.getNodeType() != 2 || "Id".equals((attr = (Attr)object).getLocalName()) && "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd".equals(attr.getNamespaceURI()) || "Value".equals(attr.getLocalName())) continue;
            throw new XWSSecurityException("The attribute " + attr.getLocalName() + "not allowed in SignatureConfirmation");
        }
    }

    public SignatureConfirmationHeaderBlock(String wsuId) {
        this.wsuId = wsuId;
    }

    public static SecurityHeaderBlock fromSoapElement(SOAPElement element) throws XWSSecurityException {
        return SecurityHeaderBlockImpl.fromSoapElement(element, SignatureConfirmationHeaderBlock.class);
    }

    @Override
    public SOAPElement getAsSoapElement() throws XWSSecurityException {
        SOAPElement signConfirm;
        try {
            Name name;
            SOAPFactory sFactory = SignatureConfirmationHeaderBlock.getSoapFactory();
            signConfirm = sFactory.createElement("SignatureConfirmation", "wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            signConfirm.addNamespaceDeclaration("wsse11", "http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd");
            try {
                if (this.signatureValue != null) {
                    name = sFactory.createName("Value");
                    signConfirm.addAttribute(name, this.signatureValue);
                }
            }
            catch (Exception ex) {
                throw new XWSSecurityException(ex);
            }
            if (this.wsuId != null) {
                name = sFactory.createName("Id", "wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
                signConfirm.addAttribute(name, this.wsuId);
            }
        }
        catch (SOAPException se) {
            throw new XWSSecurityException("There was an error creating Signature Confirmation " + se.getMessage());
        }
        this.setSOAPElement(signConfirm);
        return signConfirm;
    }

    @Override
    public String getId() {
        return this.wsuId;
    }

    public void setId(String wsuId) {
        this.wsuId = wsuId;
    }

    public String getSignatureValue() {
        return this.signatureValue;
    }

    public void setSignatureValue(String signatureValue) {
        this.signatureValue = signatureValue;
    }
}

