/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.annotation;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.application.annotation.ConfigAnnotationHandler;
import com.sun.faces.application.annotation.FacesComponentUsage;
import jakarta.faces.application.Application;
import jakarta.faces.component.FacesComponent;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ComponentConfigHandler
implements ConfigAnnotationHandler {
    private static final Collection<Class<? extends Annotation>> HANDLES = List.of(FacesComponent.class);
    private Map<String, FacesComponentUsage> components;

    @Override
    public Collection<Class<? extends Annotation>> getHandledAnnotations() {
        return HANDLES;
    }

    @Override
    public void collect(Class<?> target, Annotation annotation) {
        Object value;
        if (this.components == null) {
            this.components = new HashMap<String, FacesComponentUsage>();
        }
        if (null == (value = ((FacesComponent)annotation).value()) || 0 == ((String)value).length()) {
            value = target.getSimpleName();
            value = Character.toLowerCase(((String)value).charAt(0)) + ((String)value).substring(1);
        }
        this.components.put((String)value, new FacesComponentUsage(target, (FacesComponent)annotation));
    }

    @Override
    public void push(FacesContext ctx) {
        if (this.components != null) {
            Application app = ctx.getApplication();
            ApplicationAssociate appAss = ApplicationAssociate.getCurrentInstance();
            for (Map.Entry<String, FacesComponentUsage> entry : this.components.entrySet()) {
                if (entry.getValue().getAnnotation().createTag()) {
                    appAss.addFacesComponent(entry.getValue());
                }
                app.addComponent(entry.getKey(), entry.getValue().getTarget().getName());
            }
        }
    }
}

