/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.ws.processor.model.java;

import com.sun.tools.ws.processor.model.ModelException;
import com.sun.tools.ws.processor.model.java.JavaMethod;
import com.sun.tools.ws.util.ClassNameInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class JavaInterface {
    private String javadoc;
    private String name;
    private String realName;
    private String impl;
    private List<JavaMethod> methods = new ArrayList<JavaMethod>();
    private List<String> interfaces = new ArrayList<String>();

    public JavaInterface() {
    }

    public JavaInterface(String name) {
        this(name, null);
    }

    public JavaInterface(String name, String impl) {
        this.realName = name;
        this.name = name.replace('$', '.');
        this.impl = impl;
    }

    public String getName() {
        return this.name;
    }

    public String getFormalName() {
        return this.name;
    }

    public void setFormalName(String s) {
        this.name = s;
    }

    public String getRealName() {
        return this.realName;
    }

    public void setRealName(String s) {
        this.realName = s;
    }

    public String getImpl() {
        return this.impl;
    }

    public void setImpl(String s) {
        this.impl = s;
    }

    public Iterator<JavaMethod> getMethods() {
        return this.methods.iterator();
    }

    public boolean hasMethod(JavaMethod method) {
        for (JavaMethod javaMethod : this.methods) {
            if (!method.equals(javaMethod)) continue;
            return true;
        }
        return false;
    }

    public void addMethod(JavaMethod method) {
        if (this.hasMethod(method)) {
            throw new ModelException("model.uniqueness", new Object[0]);
        }
        this.methods.add(method);
    }

    public List<JavaMethod> getMethodsList() {
        return this.methods;
    }

    public void setMethodsList(List<JavaMethod> l) {
        this.methods = l;
    }

    public boolean hasInterface(String interfaceName) {
        for (String anInterface : this.interfaces) {
            if (!interfaceName.equals(anInterface)) continue;
            return true;
        }
        return false;
    }

    public void addInterface(String interfaceName) {
        if (this.hasInterface(interfaceName)) {
            return;
        }
        this.interfaces.add(interfaceName);
    }

    public Iterator<String> getInterfaces() {
        return this.interfaces.iterator();
    }

    public List<String> getInterfacesList() {
        return this.interfaces;
    }

    public void setInterfacesList(List<String> l) {
        this.interfaces = l;
    }

    public String getSimpleName() {
        return ClassNameInfo.getName(this.name);
    }

    public String getJavaDoc() {
        return this.javadoc;
    }

    public void setJavaDoc(String javadoc) {
        this.javadoc = javadoc;
    }
}

