/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.Arrays;
import java.util.Enumeration;

public class GlassfishUrlClassLoader
extends URLClassLoader {
    private static final System.Logger LOG = System.getLogger(GlassfishUrlClassLoader.class.getName());

    public GlassfishUrlClassLoader(String name, URL[] urls) {
        super(name, urls, ClassLoader.getSystemClassLoader());
    }

    public GlassfishUrlClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(name, urls, parent);
    }

    public GlassfishUrlClassLoader(String name, URL[] urls, ClassLoader parent, URLStreamHandlerFactory factory) {
        super(name, urls, parent, factory);
    }

    @Override
    public void addURL(URL url) {
        super.addURL(url);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        LOG.log(System.Logger.Level.TRACE, "findClass(name={0})", name);
        return super.findClass(name);
    }

    @Override
    public URL findResource(String name) {
        LOG.log(System.Logger.Level.TRACE, "findResource(name={0})", name);
        return super.findResource(name);
    }

    @Override
    public Enumeration<URL> findResources(String name) throws IOException {
        LOG.log(System.Logger.Level.TRACE, "findResources(name={0})", name);
        return super.findResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        LOG.log(System.Logger.Level.TRACE, "getResourceAsStream(name={0})", name);
        return super.getResourceAsStream(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        LOG.log(System.Logger.Level.DEBUG, "loadClass(name={0}, resolve={1})", name, resolve);
        return super.loadClass(name, resolve);
    }

    @Override
    protected Package definePackage(String name, String specTitle, String specVersion, String specVendor, String implTitle, String implVersion, String implVendor, URL sealBase) {
        LOG.log(System.Logger.Level.DEBUG, "definePackage(name={0}, specTitle={1}, specVersion={2}, specVendor={3}, implTitle={4}, implVersion={5}, implVendor={6}, sealBase={7})", name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
        return super.definePackage(name, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, sealBase);
    }

    @Override
    public void close() throws IOException {
        LOG.log(System.Logger.Level.DEBUG, "close()");
        super.close();
    }

    public String toString() {
        StringBuilder text = new StringBuilder(1024);
        text.append(this.getClass().getName()).append('@').append(Integer.toHexString(this.hashCode()));
        text.append("[name=").append(this.getName()).append("], urls=[\n");
        Arrays.stream(this.getURLs()).forEach(u -> text.append(u).append('\n'));
        text.append(']');
        return text.toString();
    }

    static {
        GlassfishUrlClassLoader.registerAsParallelCapable();
    }
}

