/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.appclient.client.acc;

import com.sun.enterprise.glassfish.bootstrap.cfg.AsenvConf;
import com.sun.enterprise.module.bootstrap.StartupContext;
import com.sun.enterprise.util.io.FileUtils;
import jakarta.inject.Singleton;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ACCStartupContext
extends StartupContext {
    public ACCStartupContext() {
        super(ACCStartupContext.accEnvironment());
    }

    private static Properties accEnvironment() {
        File rootDirectory = ACCStartupContext.getRootDirectory();
        Properties environment = AsenvConf.parseAsEnv((File)rootDirectory).toProperties();
        environment.setProperty("com.sun.aas.installRoot", rootDirectory.getAbsolutePath());
        File javadbDir = new File(rootDirectory.getParentFile(), "javadb");
        if (javadbDir.isDirectory()) {
            environment.setProperty("com.sun.aas.derbyRoot", javadbDir.getAbsolutePath());
        }
        return environment;
    }

    private static File getRootDirectory() {
        URI jarURI = null;
        try {
            jarURI = ACCStartupContext.class.getProtectionDomain().getCodeSource().getLocation().toURI();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
        if (jarURI.getScheme().startsWith("http")) {
            return FileUtils.USER_HOME;
        }
        File jarFile = new File(jarURI);
        File dirFile = jarFile.getParentFile().getParentFile();
        return dirFile;
    }
}

