/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.connectors.internal.api;

import com.sun.appserv.connectors.internal.api.AppSpecificConnectorClassLoaderUtil;
import com.sun.appserv.connectors.internal.api.ConnectorClassFinder;
import com.sun.logging.LogDomains;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.internal.api.ClassLoaderHierarchy;
import org.glassfish.internal.api.ConnectorClassLoaderService;
import org.glassfish.internal.api.DelegatingClassLoader;
import org.jvnet.hk2.annotations.Service;

@Service
public class ConnectorClassLoaderServiceImpl
implements ConnectorClassLoaderService {
    private volatile DelegatingClassLoader globalConnectorCL;
    @Inject
    private AppSpecificConnectorClassLoaderUtil appsSpecificCCLUtil;
    @Inject
    private Provider<ClassLoaderHierarchy> classLoaderHierarchyProvider;
    private Logger logger = LogDomains.getLogger(ConnectorClassLoaderServiceImpl.class, (String)"jakarta.enterprise.resource.resourceadapter");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public DelegatingClassLoader getConnectorClassLoader(String appName) {
        DelegatingClassLoader loader = null;
        if (this.globalConnectorCL == null) {
            Class<ConnectorClassLoaderServiceImpl> clazz = ConnectorClassLoaderServiceImpl.class;
            // MONITORENTER : com.sun.appserv.connectors.internal.api.ConnectorClassLoaderServiceImpl.class
            if (this.globalConnectorCL == null) {
                ClassLoader parent = this.getCommonClassLoader();
                DelegatingClassLoader newGlobalConnectorCL = new DelegatingClassLoader(parent);
                for (DelegatingClassLoader.ClassFinder classFinder : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                    newGlobalConnectorCL.addDelegate(classFinder);
                }
                for (DelegatingClassLoader.ClassFinder classFinder : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
                    newGlobalConnectorCL.addDelegate(classFinder);
                }
                this.globalConnectorCL = newGlobalConnectorCL;
            }
            // MONITOREXIT : clazz
        }
        if (this.hasGlobalAccessForRARs(appName)) {
            return this.globalConnectorCL;
        }
        this.appsSpecificCCLUtil.detectReferredRARs(appName);
        return this.createConnectorClassLoaderForApplication(appName);
    }

    private boolean hasGlobalAccessForRARs(String appName) {
        return appName == null || this.appsSpecificCCLUtil.useGlobalConnectorClassLoader() || this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName).contains("*");
    }

    private ClassLoader getCommonClassLoader() {
        return this.classLoaderHierarchyProvider.get().getCommonClassLoader();
    }

    private DelegatingClassLoader createConnectorClassLoaderForApplication(String appName) {
        DelegatingClassLoader appSpecificConnectorClassLoader = new DelegatingClassLoader(this.getCommonClassLoader());
        for (DelegatingClassLoader.ClassFinder classFinder : this.appsSpecificCCLUtil.getSystemRARClassLoaders()) {
            appSpecificConnectorClassLoader.addDelegate(classFinder);
        }
        for (String string : this.appsSpecificCCLUtil.getRARsReferredByApplication(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, string);
        }
        for (String string : this.appsSpecificCCLUtil.getRequiredResourceAdapters(appName)) {
            this.addRarClassLoader(appName, appSpecificConnectorClassLoader, string);
        }
        return appSpecificConnectorClassLoader;
    }

    private void addRarClassLoader(String appName, DelegatingClassLoader appSpecificConnectorClassLoader, String raName) {
        DelegatingClassLoader.ClassFinder classFinder;
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.finest("raName for app [ " + appName + " ] : " + raName);
        }
        if ((classFinder = this.getClassFinder(raName)) != null) {
            appSpecificConnectorClassLoader.addDelegate(classFinder);
        }
    }

    private DelegatingClassLoader.ClassFinder getClassFinder(String raName) {
        List delegates = this.globalConnectorCL.getDelegates();
        DelegatingClassLoader.ClassFinder classFinder = null;
        for (DelegatingClassLoader.ClassFinder cf : delegates) {
            if (!raName.equals(((ConnectorClassFinder)cf).getResourceAdapterName())) continue;
            classFinder = cf;
            break;
        }
        return classFinder;
    }
}

