/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.config.Config;
import io.helidon.config.ConfigException;
import io.helidon.config.ConfigSourceRuntime;
import io.helidon.config.MetaConfig;
import io.helidon.config.ObjectNodeBuilderImpl;
import io.helidon.config.spi.ConfigContent;
import io.helidon.config.spi.ConfigContext;
import io.helidon.config.spi.ConfigNode;
import io.helidon.config.spi.ConfigSource;
import io.helidon.config.spi.EventConfigSource;
import io.helidon.config.spi.NodeConfigSource;
import io.helidon.config.spi.RetryPolicy;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public final class PrefixedConfigSource
implements ConfigSource,
NodeConfigSource,
EventConfigSource {
    private static final String KEY_KEY = "key";
    private final String key;
    private final ConfigSource source;
    private BiConsumer<String, ConfigNode> listener;
    private ConfigSourceRuntime sourceRuntime;

    private PrefixedConfigSource(String key, ConfigSource source) {
        Objects.requireNonNull(key, "key cannot be null");
        Objects.requireNonNull(source, "source cannot be null");
        this.key = key;
        this.source = source;
    }

    public static PrefixedConfigSource create(Config metaConfig) {
        String prefix = (String)metaConfig.get(KEY_KEY).asString().orElse("");
        ConfigSource configSource = MetaConfig.configSource(metaConfig).get(0);
        return PrefixedConfigSource.create(prefix, configSource);
    }

    public static PrefixedConfigSource create(String key, ConfigSource source) {
        return new PrefixedConfigSource(key, source);
    }

    public void init(ConfigContext context) {
        this.sourceRuntime = context.sourceRuntime(this.source);
    }

    public String description() {
        return String.format("prefixed[%s]:%s", this.key, this.source.description());
    }

    public Optional<ConfigContent.NodeContent> load() throws ConfigException {
        this.sourceRuntime.onChange((key, config) -> this.listener.accept((String)key, (ConfigNode)config));
        return this.sourceRuntime.load().map(originRoot -> ConfigContent.NodeContent.builder().node(new ObjectNodeBuilderImpl().addObject(this.key, (ConfigNode.ObjectNode)originRoot).build()).build());
    }

    public void onChange(BiConsumer<String, ConfigNode> changedNode) {
        this.listener = changedNode;
    }

    public boolean exists() {
        return this.source.exists();
    }

    public Optional<RetryPolicy> retryPolicy() {
        return this.source.retryPolicy();
    }

    public boolean optional() {
        return this.source.optional();
    }
}

