/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.history.AsOfClause;
import org.eclipse.persistence.history.HistoryPolicy;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLUpdateStatement;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.CollectionMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.RelationTableMechanism;
import org.eclipse.persistence.mappings.RelationalMapping;
import org.eclipse.persistence.mappings.foundation.MapComponentMapping;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.DataModifyQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.InsertObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class ManyToManyMapping
extends CollectionMapping
implements RelationalMapping,
MapComponentMapping {
    protected static final String PostInsert = "postInsert";
    protected static final String ObjectRemoved = "objectRemoved";
    protected static final String ObjectAdded = "objectAdded";
    protected RelationTableMechanism mechanism = new RelationTableMechanism();
    protected HistoryPolicy historyPolicy;
    protected boolean isDefinedAsOneToManyMapping = false;

    public ManyToManyMapping() {
        this.isListOrderFieldSupported = true;
    }

    @Override
    public boolean isOwned() {
        return !this.isReadOnly;
    }

    @Override
    public boolean isRelationalMapping() {
        return true;
    }

    public void addSourceRelationKeyField(DatabaseField sourceRelationKeyField, DatabaseField sourcePrimaryKeyField) {
        this.mechanism.addSourceRelationKeyField(sourceRelationKeyField, sourcePrimaryKeyField);
    }

    public void addSourceRelationKeyFieldName(String sourceRelationKeyFieldName, String sourcePrimaryKeyFieldName) {
        this.mechanism.addSourceRelationKeyFieldName(sourceRelationKeyFieldName, sourcePrimaryKeyFieldName);
    }

    public void addTargetRelationKeyField(DatabaseField targetRelationKeyField, DatabaseField targetPrimaryKeyField) {
        this.mechanism.addTargetRelationKeyField(targetRelationKeyField, targetPrimaryKeyField);
    }

    public void addTargetRelationKeyFieldName(String targetRelationKeyFieldName, String targetPrimaryKeyFieldName) {
        this.mechanism.addTargetRelationKeyFieldName(targetRelationKeyFieldName, targetPrimaryKeyFieldName);
    }

    @Override
    public void collectQueryParameters(Set<DatabaseField> cacheFields) {
        this.mechanism.collectQueryParameters(cacheFields);
    }

    @Override
    public Object clone() {
        ManyToManyMapping clone = (ManyToManyMapping)super.clone();
        clone.mechanism = (RelationTableMechanism)this.mechanism.clone();
        return clone;
    }

    @Override
    public void earlyPreDelete(DeleteObjectQuery query, Object object) {
        AbstractSession querySession = query.getSession();
        if (!this.isCascadeOnDeleteSetOnDatabase) {
            this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), querySession);
            querySession.executeQuery((DatabaseQuery)this.deleteAllQuery, query.getTranslationRow());
        }
        if (this.historyPolicy != null && this.historyPolicy.shouldHandleWrites()) {
            if (this.isCascadeOnDeleteSetOnDatabase) {
                this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), querySession);
            }
            this.historyPolicy.mappingLogicalDelete(this.deleteAllQuery, query.getTranslationRow(), querySession);
        }
    }

    @Override
    public Object createMapComponentFromRow(AbstractRecord dbRow, ObjectBuildingQuery query, CacheKey parentCacheKey, AbstractSession session, boolean isTargetProtected) {
        return session.executeQuery((DatabaseQuery)this.getSelectionQuery(), dbRow);
    }

    @Override
    protected void extendPessimisticLockScopeInTargetQuery(ObjectLevelReadQuery targetQuery, ObjectBuildingQuery sourceQuery) {
        this.mechanism.setRelationTableLockingClause(targetQuery, sourceQuery);
    }

    @Override
    public void extendPessimisticLockScopeInSourceQuery(ObjectLevelReadQuery sourceQuery) {
        Expression exp = sourceQuery.getSelectionCriteria();
        exp = this.mechanism.joinRelationTableField(exp, sourceQuery.getExpressionBuilder());
        sourceQuery.setSelectionCriteria(exp);
    }

    @Override
    protected Object extractKeyFromTargetRow(AbstractRecord row, AbstractSession session) {
        return this.mechanism.extractKeyFromTargetRow(row, session);
    }

    @Override
    protected Object extractBatchKeyFromRow(AbstractRecord row, AbstractSession session) {
        return this.mechanism.extractBatchKeyFromRow(row, session);
    }

    @Override
    protected Expression buildBatchCriteria(ExpressionBuilder builder, ObjectLevelReadQuery query) {
        return this.mechanism.buildBatchCriteria(builder, query);
    }

    @Override
    protected void postPrepareNestedBatchQuery(ReadQuery batchQuery, ObjectLevelReadQuery query) {
        super.postPrepareNestedBatchQuery(batchQuery, query);
        ReadAllQuery mappingBatchQuery = (ReadAllQuery)batchQuery;
        this.mechanism.postPrepareNestedBatchQuery(batchQuery, query);
        if (this.historyPolicy != null) {
            ExpressionBuilder builder = mappingBatchQuery.getExpressionBuilder();
            Expression twisted = batchQuery.getSelectionCriteria();
            if (query.getSession().getAsOfClause() != null) {
                builder.asOf(query.getSession().getAsOfClause());
            } else if (builder.getAsOfClause() == null) {
                builder.asOf(AsOfClause.NO_CLAUSE);
            }
            twisted = twisted.and(this.historyPolicy.additionalHistoryExpression(builder, builder));
            mappingBatchQuery.setSelectionCriteria(twisted);
        }
    }

    @Override
    protected Expression getAdditionalFieldsBaseExpression(ReadQuery query) {
        return ((ReadAllQuery)query).getExpressionBuilder().getTable(this.getRelationTable());
    }

    protected DataModifyQuery getDeleteQuery() {
        return this.mechanism.getDeleteQuery();
    }

    @Override
    protected ReadQuery getExtendPessimisticLockScopeDedicatedQuery(AbstractSession session, short lockMode) {
        if (this.mechanism != null) {
            return this.mechanism.getLockRelationTableQueryClone(session, lockMode);
        }
        return super.getExtendPessimisticLockScopeDedicatedQuery(session, lockMode);
    }

    @Override
    public Collection<DatabaseField> getFieldsForTranslationInAggregate() {
        return this.getRelationTableMechanism().getSourceKeyFields();
    }

    protected DataModifyQuery getInsertQuery() {
        return this.mechanism.getInsertQuery();
    }

    @Override
    public Expression getJoinCriteria(ObjectExpression context, Expression base) {
        if (this.getHistoryPolicy() != null) {
            Expression result = super.getJoinCriteria(context, base);
            Expression historyCriteria = this.getHistoryPolicy().additionalHistoryExpression(context, base);
            if (result != null) {
                return result.and(historyCriteria);
            }
            if (historyCriteria != null) {
                return historyCriteria;
            }
            return null;
        }
        return super.getJoinCriteria(context, base);
    }

    public HistoryPolicy getHistoryPolicy() {
        return this.historyPolicy;
    }

    public RelationTableMechanism getRelationTableMechanism() {
        return this.mechanism;
    }

    public DatabaseTable getRelationTable() {
        return this.mechanism.getRelationTable();
    }

    public String getRelationTableName() {
        return this.mechanism.getRelationTableName();
    }

    public String getRelationTableQualifiedName() {
        return this.mechanism.getRelationTableQualifiedName();
    }

    public List<String> getSourceKeyFieldNames() {
        return this.mechanism.getSourceKeyFieldNames();
    }

    public List<DatabaseField> getSourceKeyFields() {
        return this.mechanism.getSourceKeyFields();
    }

    public List<String> getSourceRelationKeyFieldNames() {
        return this.mechanism.getSourceRelationKeyFieldNames();
    }

    public List<DatabaseField> getSourceRelationKeyFields() {
        return this.mechanism.getSourceRelationKeyFields();
    }

    public List<String> getTargetKeyFieldNames() {
        return this.mechanism.getTargetKeyFieldNames();
    }

    public List<DatabaseField> getTargetKeyFields() {
        return this.mechanism.getTargetKeyFields();
    }

    public List<String> getTargetRelationKeyFieldNames() {
        return this.mechanism.getTargetRelationKeyFieldNames();
    }

    public List<DatabaseField> getTargetRelationKeyFields() {
        return this.mechanism.getTargetRelationKeyFields();
    }

    protected boolean hasCustomDeleteQuery() {
        return this.mechanism.hasCustomDeleteQuery();
    }

    protected boolean hasCustomInsertQuery() {
        return this.mechanism.hasCustomInsertQuery();
    }

    @Override
    public boolean hasDependency() {
        return this.isPrivateOwned || !this.isReadOnly;
    }

    @Override
    public void initialize(AbstractSession session) throws DescriptorException {
        if (session.hasBroker()) {
            if (this.getReferenceClass() == null) {
                throw DescriptorException.referenceClassNotSpecified(this);
            }
            session = session.getBroker().getSessionForClass(this.getReferenceClass());
        }
        super.initialize(session);
        this.getDescriptor().addPreDeleteMapping(this);
        if (this.mechanism == null) {
            throw DescriptorException.noRelationTableMechanism(this);
        }
        this.mechanism.initialize(session, this);
        if (this.shouldInitializeSelectionCriteria()) {
            if (this.shouldForceInitializationOfSelectionCriteria()) {
                this.initializeSelectionCriteriaAndAddFieldsToQuery(null);
            } else {
                this.initializeSelectionCriteriaAndAddFieldsToQuery(this.getSelectionCriteria());
            }
        }
        if (!this.getSelectionQuery().hasSessionName()) {
            this.getSelectionQuery().setSessionName(session.getName());
        }
        this.initializeDeleteAllQuery(session);
        if (this.getHistoryPolicy() != null) {
            this.getHistoryPolicy().initialize(session);
        }
    }

    @Override
    protected void buildListOrderField() {
        if (this.listOrderField.hasTableName()) {
            if (!this.getRelationTable().equals(this.listOrderField.getTable())) {
                throw DescriptorException.listOrderFieldTableIsWrong(this.getDescriptor(), this, this.listOrderField.getTable(), this.getRelationTable());
            }
        } else {
            this.listOrderField.setTable(this.getRelationTable());
        }
        this.listOrderField = this.getDescriptor().buildField(this.listOrderField, this.getRelationTable());
    }

    @Override
    public boolean shouldUseListOrderFieldTableExpression() {
        return true;
    }

    @Override
    protected void initializeChangeOrderTargetQuery(AbstractSession session) {
        boolean hasChangeOrderTargetQuery;
        boolean bl = hasChangeOrderTargetQuery = this.changeOrderTargetQuery != null;
        if (!hasChangeOrderTargetQuery) {
            this.changeOrderTargetQuery = new DataModifyQuery();
        }
        this.changeOrderTargetQuery = new DataModifyQuery();
        if (!this.changeOrderTargetQuery.hasSessionName()) {
            this.changeOrderTargetQuery.setSessionName(session.getName());
        }
        if (hasChangeOrderTargetQuery) {
            return;
        }
        Expression whereClause = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        List<DatabaseField> sourceRelationKeyFields = this.getSourceRelationKeyFields();
        int size = sourceRelationKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField sourceRelationKeyField = sourceRelationKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(sourceRelationKeyField).equal(builder.getParameter(sourceRelationKeyField));
            whereClause = expression.and(whereClause);
        }
        List<DatabaseField> targetRelationKeyFields = this.getTargetRelationKeyFields();
        size = targetRelationKeyFields.size();
        for (int index = 0; index < size; ++index) {
            DatabaseField targetRelationKeyField = targetRelationKeyFields.get(index);
            Expression expression = ((Expression)builder).getField(targetRelationKeyField).equal(builder.getParameter(targetRelationKeyField));
            whereClause = expression.and(whereClause);
        }
        DatabaseRecord modifyRow = new DatabaseRecord();
        modifyRow.add(this.listOrderField, null);
        SQLUpdateStatement statement = new SQLUpdateStatement();
        statement.setTable(this.listOrderField.getTable());
        statement.setWhereClause(whereClause);
        statement.setModifyRow(modifyRow);
        this.changeOrderTargetQuery.setSQLStatement(statement);
    }

    protected void initializeDeleteAllQuery(AbstractSession session) {
        if (!this.getDeleteAllQuery().hasSessionName()) {
            this.getDeleteAllQuery().setSessionName(session.getName());
        }
        this.getDeleteAllQuery().setName(this.getAttributeName());
        if (this.getDeleteAllQuery().getPartitioningPolicy() == null) {
            this.getDeleteAllQuery().setPartitioningPolicy(this.getPartitioningPolicy());
        }
        if (this.hasCustomDeleteAllQuery()) {
            return;
        }
        Expression expression = null;
        ExpressionBuilder builder = new ExpressionBuilder();
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getSourceRelationKeyFields().size(); ++index) {
            DatabaseField sourceRelationKey = this.getSourceRelationKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExpression = ((Expression)builder).getField(sourceRelationKey).equal(builder.getParameter(sourceKey));
            expression = subExpression.and(expression);
        }
        statement.setWhereClause(expression);
        statement.setTable(this.getRelationTable());
        this.getDeleteAllQuery().setSQLStatement(statement);
    }

    @Override
    protected void initializeListOrderFieldTable(AbstractSession session) {
        this.mechanism.initializeRelationTable(session, this);
    }

    protected void initializeSelectionCriteriaAndAddFieldsToQuery(Expression startCriteria) {
        this.setSelectionCriteria(this.mechanism.buildSelectionCriteriaAndAddFieldsToQuery(this, startCriteria));
    }

    protected void insertAddedObjectEntry(ObjectLevelModifyQuery query, Object objectAdded, Map extraData) throws DatabaseException, OptimisticLockException {
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        AbstractRecord databaseRow = this.mechanism.buildRelationTableSourceAndTargetRow(query.getTranslationRow(), this.containerPolicy.unwrapIteratorResult(objectAdded), query.getSession(), (ForeignReferenceMapping)this);
        ContainerPolicy.copyMapDataToRow(this.getContainerPolicy().getKeyMappingDataForWriteQuery(objectAdded, query.getSession()), databaseRow);
        if (this.listOrderField != null && extraData != null) {
            databaseRow.put(this.listOrderField, extraData.get(this.listOrderField));
        }
        query.getExecutionSession().executeQuery((DatabaseQuery)this.mechanism.getInsertQuery(), databaseRow);
        if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
            this.getHistoryPolicy().mappingLogicalInsert(this.mechanism.getInsertQuery(), databaseRow, query.getSession());
        }
    }

    public void insertIntoRelationTable(WriteObjectQuery query) throws DatabaseException {
        Object objects;
        if (this.isReadOnly()) {
            return;
        }
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession()))) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        AbstractRecord databaseRow = this.mechanism.buildRelationTableSourceRow(query.getTranslationRow());
        int orderIndex = 0;
        Object iter = cp.iteratorFor(objects);
        while (cp.hasNext(iter)) {
            Object wrappedObject = cp.nextEntry(iter, query.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            databaseRow = this.mechanism.addRelationTableTargetRow(object, query.getExecutionSession(), databaseRow, this);
            ContainerPolicy.copyMapDataToRow(cp.getKeyMappingDataForWriteQuery(wrappedObject, query.getSession()), databaseRow);
            if (this.listOrderField != null) {
                databaseRow.put(this.listOrderField, (Object)orderIndex++);
            }
            query.getExecutionSession().executeQuery((DatabaseQuery)this.mechanism.getInsertQuery(), databaseRow);
            if (this.getHistoryPolicy() == null || !this.getHistoryPolicy().shouldHandleWrites()) continue;
            this.getHistoryPolicy().mappingLogicalInsert(this.mechanism.getInsertQuery(), databaseRow, query.getSession());
        }
    }

    public void insertTargetObjects(WriteObjectQuery query) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(query)) {
            return;
        }
        if (query.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        ContainerPolicy cp = this.getContainerPolicy();
        if (cp.isEmpty(objects)) {
            return;
        }
        Object objectsIterator = cp.iteratorFor(objects);
        while (cp.hasNext(objectsIterator)) {
            Object wrappedObject = cp.next(objectsIterator, query.getSession());
            Object object = cp.unwrapIteratorResult(wrappedObject);
            if (this.isPrivateOwned()) {
                InsertObjectQuery insertQuery = new InsertObjectQuery();
                insertQuery.setIsExecutionClone(true);
                insertQuery.setObject(object);
                insertQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(insertQuery);
            } else {
                ObjectChangeSet changeSet = null;
                UnitOfWorkChangeSet uowChangeSet = null;
                if (query.getSession().isUnitOfWork() && ((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet() != null) {
                    uowChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)query.getSession()).getUnitOfWorkChangeSet();
                    changeSet = (ObjectChangeSet)uowChangeSet.getObjectChangeSetForClone(object);
                }
                WriteObjectQuery writeQuery = new WriteObjectQuery();
                writeQuery.setIsExecutionClone(true);
                writeQuery.setObject(object);
                writeQuery.setObjectChangeSet(changeSet);
                writeQuery.setCascadePolicy(query.getCascadePolicy());
                query.getSession().executeQuery(writeQuery);
            }
            cp.propogatePostInsert(query, wrappedObject);
        }
    }

    public boolean isDefinedAsOneToManyMapping() {
        return this.isDefinedAsOneToManyMapping;
    }

    @Override
    public boolean isJoiningSupported() {
        return true;
    }

    @Override
    public boolean isManyToManyMapping() {
        return true;
    }

    @Override
    public void postInitialize(AbstractSession session) {
        super.postInitialize(session);
        this.mustDeleteReferenceObjectsOneByOne = true;
    }

    @Override
    protected void objectAddedDuringUpdate(ObjectLevelModifyQuery query, Object objectAdded, ObjectChangeSet changeSet, Map extraData) throws DatabaseException, OptimisticLockException {
        super.objectAddedDuringUpdate(query, objectAdded, changeSet, extraData);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{ObjectAdded, query, objectAdded, extraData};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.insertAddedObjectEntry(query, objectAdded, extraData);
        }
    }

    @Override
    protected void objectRemovedDuringUpdate(ObjectLevelModifyQuery query, Object objectDeleted, Map extraData) throws DatabaseException, OptimisticLockException {
        Object unwrappedObjectDeleted = this.getContainerPolicy().unwrapIteratorResult(objectDeleted);
        AbstractRecord databaseRow = this.mechanism.buildRelationTableSourceAndTargetRow(query.getTranslationRow(), unwrappedObjectDeleted, query.getSession(), (ForeignReferenceMapping)this);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{ObjectRemoved, this.mechanism.getDeleteQuery(), databaseRow};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            query.getSession().executeQuery((DatabaseQuery)this.mechanism.getDeleteQuery(), databaseRow);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete(this.mechanism.getDeleteQuery(), databaseRow, query.getSession());
            }
        }
        super.objectRemovedDuringUpdate(query, objectDeleted, extraData);
    }

    @Override
    protected void objectOrderChangedDuringUpdate(WriteObjectQuery query, Object orderChangedObject, int orderIndex) {
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getDescriptor(), query.getSession());
        AbstractRecord databaseRow = this.mechanism.buildRelationTableSourceAndTargetRow(query.getTranslationRow(), orderChangedObject, query.getSession(), (ForeignReferenceMapping)this);
        databaseRow.put(this.listOrderField, (Object)orderIndex);
        query.getSession().executeQuery((DatabaseQuery)this.changeOrderTargetQuery, databaseRow);
    }

    @Override
    public void performDataModificationEvent(Object[] event, AbstractSession session) throws DatabaseException, DescriptorException {
        if (event[0] == PostInsert) {
            this.insertIntoRelationTable((WriteObjectQuery)event[1]);
        } else if (event[0] == ObjectRemoved) {
            session.executeQuery((DatabaseQuery)((DataModifyQuery)event[1]), (AbstractRecord)event[2]);
            if (this.getHistoryPolicy() != null && this.getHistoryPolicy().shouldHandleWrites()) {
                this.getHistoryPolicy().mappingLogicalDelete((DataModifyQuery)event[1], (AbstractRecord)event[2], session);
            }
        } else if (event[0] == ObjectAdded) {
            this.insertAddedObjectEntry((WriteObjectQuery)event[1], event[2], (Map)event[3]);
        } else {
            throw DescriptorException.invalidDataModificationEventCode(event[0], this);
        }
    }

    @Override
    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        this.insertTargetObjects(query);
        if (query.shouldCascadeOnlyDependentParts()) {
            Object[] event = new Object[]{PostInsert, query};
            query.getSession().getCommitManager().addDataModificationEvent(this, event);
        } else {
            this.insertIntoRelationTable(query);
        }
    }

    @Override
    public void postUpdate(WriteObjectQuery query) throws DatabaseException {
        if (this.isReadOnly) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(query.getObject())) {
            return;
        }
        if (query.getObjectChangeSet() != null) {
            this.writeChanges(query.getObjectChangeSet(), query);
        } else {
            this.compareObjectsAndWrite(query);
        }
    }

    @Override
    public void preDelete(DeleteObjectQuery query) throws DatabaseException {
        AbstractSession session = query.getSession();
        Object objectsIterator = null;
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.isReadOnly) {
            return;
        }
        Object objects = null;
        boolean cascade = this.shouldObjectModifyCascadeToParts(query);
        if (containerPolicy.propagatesEventsToCollection() || cascade) {
            objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), session);
            objectsIterator = containerPolicy.iteratorFor(objects);
        }
        if (!session.isUnitOfWork()) {
            this.earlyPreDelete(query, query.getObject());
        }
        if ((containerPolicy.propagatesEventsToCollection() || cascade) && objects != null) {
            while (containerPolicy.hasNext(objectsIterator)) {
                Object wrappedObject = containerPolicy.nextEntry(objectsIterator, session);
                Object object = containerPolicy.unwrapIteratorResult(wrappedObject);
                if (cascade && !session.getCommitManager().isCommitCompletedInPostOrIgnore(object)) {
                    DeleteObjectQuery deleteQuery = new DeleteObjectQuery();
                    deleteQuery.setIsExecutionClone(true);
                    deleteQuery.setObject(object);
                    deleteQuery.setCascadePolicy(query.getCascadePolicy());
                    session.executeQuery(deleteQuery);
                }
                containerPolicy.propogatePreDelete(query, wrappedObject);
            }
        }
    }

    @Override
    protected void prepareTranslationRow(AbstractRecord translationRow, Object object, ClassDescriptor descriptor, AbstractSession session) {
        for (DatabaseField sourceKey : this.getSourceKeyFields()) {
            if (translationRow.containsKey(sourceKey)) continue;
            Object value = descriptor.getObjectBuilder().extractValueFromObjectForField(object, sourceKey, session);
            translationRow.put(sourceKey, value);
        }
    }

    public void setCustomDeleteQuery(DataModifyQuery query) {
        this.mechanism.setCustomDeleteQuery(query);
    }

    public void setCustomInsertQuery(DataModifyQuery query) {
        this.mechanism.setCustomInsertQuery(query);
    }

    protected void setDeleteQuery(DataModifyQuery deleteQuery) {
        this.mechanism.setDeleteQuery(deleteQuery);
    }

    public void setDeleteSQLString(String sqlString) {
        this.mechanism.setDeleteSQLString(sqlString);
    }

    public void setDefinedAsOneToManyMapping(boolean isDefinedAsOneToManyMapping) {
        this.isDefinedAsOneToManyMapping = isDefinedAsOneToManyMapping;
    }

    public void setDeleteCall(Call call) {
        this.mechanism.setDeleteCall(call);
    }

    protected void setInsertQuery(DataModifyQuery insertQuery) {
        this.mechanism.setInsertQuery(insertQuery);
    }

    public void setInsertSQLString(String sqlString) {
        this.mechanism.setInsertSQLString(sqlString);
    }

    public void setInsertCall(Call call) {
        this.mechanism.setInsertCall(call);
    }

    void setRelationTableMechanism(RelationTableMechanism mechanism) {
        this.mechanism = mechanism;
    }

    public void setRelationTable(DatabaseTable relationTable) {
        this.mechanism.setRelationTable(relationTable);
    }

    public void setHistoryPolicy(HistoryPolicy policy) {
        this.historyPolicy = policy;
        if (policy != null) {
            policy.setMapping(this);
        }
    }

    public void setRelationTableName(String tableName) {
        this.mechanism.setRelationTableName(tableName);
    }

    @Override
    public void setSessionName(String name) {
        super.setSessionName(name);
        this.mechanism.setSessionName(name);
    }

    public void setSourceKeyFieldNames(List<String> fieldNames) {
        this.mechanism.setSourceKeyFieldNames(fieldNames);
    }

    public void setSourceKeyFields(List<DatabaseField> sourceKeyFields) {
        this.mechanism.setSourceKeyFields(sourceKeyFields);
    }

    public void setSourceRelationKeyFieldName(String sourceRelationKeyFieldName) {
        this.mechanism.setSourceRelationKeyFieldName(sourceRelationKeyFieldName);
    }

    public void setSourceRelationKeyFieldNames(List<String> fieldNames) {
        this.mechanism.setSourceRelationKeyFieldNames(fieldNames);
    }

    public void setSourceRelationKeyFields(List<DatabaseField> sourceRelationKeyFields) {
        this.mechanism.setSourceRelationKeyFields(sourceRelationKeyFields);
    }

    public void setTargetKeyFieldNames(List<String> fieldNames) {
        this.mechanism.setTargetKeyFieldNames(fieldNames);
    }

    public void setTargetKeyFields(List<DatabaseField> targetKeyFields) {
        this.mechanism.setTargetKeyFields(targetKeyFields);
    }

    public void setTargetRelationKeyFieldName(String targetRelationKeyFieldName) {
        this.mechanism.setTargetRelationKeyFieldName(targetRelationKeyFieldName);
    }

    public void setTargetRelationKeyFieldNames(List<String> fieldNames) {
        this.mechanism.setTargetRelationKeyFieldNames(fieldNames);
    }

    public void setTargetRelationKeyFields(List<DatabaseField> targetRelationKeyFields) {
        this.mechanism.setTargetRelationKeyFields(targetRelationKeyFields);
    }

    @Override
    protected ReadQuery prepareHistoricalQuery(ReadQuery targetQuery, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) {
        if (this.getHistoryPolicy() != null) {
            if (targetQuery == this.getSelectionQuery()) {
                targetQuery = (ObjectLevelReadQuery)targetQuery.clone();
                targetQuery.setIsExecutionClone(true);
            }
            if (targetQuery.getSelectionCriteria() == this.getSelectionQuery().getSelectionCriteria()) {
                targetQuery.setSelectionCriteria(targetQuery.getSelectionCriteria().clone());
            }
            if (sourceQuery.getSession().getAsOfClause() != null) {
                ((ObjectLevelReadQuery)targetQuery).setAsOfClause(sourceQuery.getSession().getAsOfClause());
            } else if (((ObjectLevelReadQuery)targetQuery).getAsOfClause() == null) {
                ((ObjectLevelReadQuery)targetQuery).setAsOfClause(AsOfClause.NO_CLAUSE);
            }
            Expression temporalExpression = this.getHistoryPolicy().additionalHistoryExpression(targetQuery.getSelectionCriteria().getBuilder(), targetQuery.getSelectionCriteria().getBuilder());
            targetQuery.setSelectionCriteria(targetQuery.getSelectionCriteria().and(temporalExpression));
        }
        return targetQuery;
    }
}

