/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.sun.enterprise.config.serverbeans.Domain;
import java.util.Properties;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.batch.AbstractListCommandProxy;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-batch-job-executions")
@PerLookup
@CommandLock(value=CommandLock.LockType.NONE)
@I18n(value="list.batch.job.executions")
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.DAS, CommandTarget.STANDALONE_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.GET, path="list-batch-job-executions", description="List Batch Job Executions")})
public class ListBatchJobExecutionsProxy
extends AbstractListCommandProxy {
    @Param(name="executionid", shortName="x", optional=true)
    String executionId;
    @Param(primary=true, optional=true)
    String instanceId;

    @Override
    protected String getCommandName() {
        return "_ListBatchJobExecutions";
    }

    @Override
    protected boolean preInvoke(AdminCommandContext ctx, ActionReport subReport) {
        if (this.executionId != null && !this.isLongNumber(this.executionId)) {
            subReport.setMessage("execution ID must be a number");
            return false;
        }
        if (this.instanceId != null && !this.isLongNumber(this.instanceId)) {
            subReport.setMessage("instance ID must be a number");
            return false;
        }
        return true;
    }

    @Override
    protected void fillParameterMap(ParameterMap parameterMap) {
        super.fillParameterMap(parameterMap);
        if (this.executionId != null) {
            parameterMap.add((Object)"executionid", (Object)this.executionId);
        }
        if (this.instanceId != null) {
            parameterMap.add((Object)"DEFAULT", (Object)this.instanceId);
        }
    }

    @Override
    protected void postInvoke(AdminCommandContext context, ActionReport subReport) {
        Properties subProperties = subReport.getExtraProperties();
        Properties extraProps = context.getActionReport().getExtraProperties();
        if (subProperties.get("listBatchJobExecutions") != null) {
            extraProps.put("listBatchJobExecutions", subProperties.get("listBatchJobExecutions"));
        }
    }
}

