/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.NativeRemoteCommandsBase;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.io.FileListerRelative;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFileException;
import com.sun.enterprise.util.zip.ZipWriter;
import jakarta.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.cluster.ssh.sftp.SFTPPath;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
abstract class InstallNodeBaseCommand
extends NativeRemoteCommandsBase {
    @Param(name="archive", optional=true)
    private String archive;
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean create;
    @Param(optional=true, defaultValue="false")
    private boolean save;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private ServiceLocator habitat;
    private String archiveName;
    private boolean delete = true;

    InstallNodeBaseCommand() {
    }

    abstract void copyToHosts(File var1, List<SFTPPath> var2) throws CommandException;

    abstract void precopy() throws CommandException;

    @Override
    protected void validate() throws CommandException {
        super.validate();
        Globals.setDefaultHabitat((ServiceLocator)this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (InstallNodeBaseCommand.ok((String)this.archive)) {
            this.archive = SmartFile.sanitize((String)this.archive);
        }
    }

    protected int executeCommand() throws CommandException {
        File zipFile = null;
        try {
            ArrayList<SFTPPath> binDirFiles = new ArrayList<SFTPPath>();
            this.precopy();
            zipFile = this.createZipFileIfNeeded(binDirFiles);
            this.copyToHosts(zipFile, binDirFiles);
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException((Throwable)e);
        }
        finally {
            if (!this.save && this.delete && zipFile != null && !zipFile.delete()) {
                zipFile.deleteOnExit();
            }
        }
        return 0;
    }

    final String getInstallDir() {
        return this.installDir;
    }

    final String getArchiveName() {
        return this.archiveName;
    }

    final boolean getForce() {
        return this.force;
    }

    private File createZipFileIfNeeded(List<SFTPPath> binDirFiles) throws IOException, ZipFileException {
        File zipFile;
        String baseRootValue = this.getSystemProperty("com.sun.aas.productRoot");
        File installRoot = new File(baseRootValue);
        if (this.archive == null) {
            zipFile = File.createTempFile("glassfish", ".zip");
        } else {
            zipFile = new File(this.archive);
            File zipFileDir = new File(this.archive.substring(0, this.archive.lastIndexOf("/")));
            if (zipFile.exists() && !this.create) {
                logger.log(Level.FINER, "Found {0}", this.archive);
                this.delete = false;
                return zipFile;
            }
            if (!zipFileDir.canWrite()) {
                throw new IOException("Cannot write to " + this.archive);
            }
        }
        this.archiveName = zipFile.getName();
        FileListerRelative lister = new FileListerRelative(installRoot);
        lister.keepEmptyDirectories();
        String[] files = lister.getFiles();
        ArrayList<String> resultFiles = new ArrayList<String>(Arrays.asList(files));
        logger.finer(() -> "Number of files to be zipped = " + resultFiles.size());
        Iterator<String> iter = resultFiles.iterator();
        while (iter.hasNext()) {
            File file = new File(iter.next());
            SFTPPath path = SFTPPath.of((File)file);
            if (this.archiveName.equals(file.getName())) {
                logger.log(Level.FINER, "Removing file = {0}", path);
                iter.remove();
                continue;
            }
            if (path.contains("domains") || path.contains("nodes")) {
                iter.remove();
                continue;
            }
            if (!InstallNodeBaseCommand.isFileWithinBinDirectory((Path)path) && !"nadmin".equals(file.getName())) continue;
            binDirFiles.add(path);
        }
        logger.finer(() -> "Final number of files to be zipped = " + resultFiles.size());
        String[] filesToZip = new String[resultFiles.size()];
        filesToZip = resultFiles.toArray(filesToZip);
        ZipWriter writer = new ZipWriter(FileUtils.safeGetCanonicalPath((File)zipFile), installRoot.toString(), filesToZip);
        writer.safeWrite();
        logger.info("Created installation zip " + FileUtils.safeGetCanonicalPath((File)zipFile));
        return zipFile;
    }

    private static boolean isFileWithinBinDirectory(Path path) {
        Path parent = path.getParent();
        if (parent == null || parent.getFileName() == null) {
            return false;
        }
        return parent.getFileName().toString().equals("bin");
    }

    public static String toString(InputStream ins) throws IOException {
        int n;
        StringWriter sw = new StringWriter();
        InputStreamReader reader = new InputStreamReader(ins);
        char[] buffer = new char[4096];
        while ((n = reader.read(buffer)) >= 0) {
            sw.write(buffer, 0, n);
        }
        return sw.toString();
    }
}

