/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.deserializer.types;

import java.time.Instant;
import java.time.MonthDay;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.eclipse.yasson.internal.deserializer.types.AbstractDateDeserializer;
import org.eclipse.yasson.internal.deserializer.types.TypeDeserializerBuilder;

class MonthDayTypeDeserializer
extends AbstractDateDeserializer<MonthDay> {
    private static final DateTimeFormatter DEFAULT_FORMAT = DateTimeFormatter.ofPattern("--MM-dd").withZone(UTC);

    MonthDayTypeDeserializer(TypeDeserializerBuilder builder) {
        super(builder);
    }

    @Override
    protected MonthDay fromInstant(Instant instant) {
        return MonthDay.from(instant.atZone(UTC));
    }

    @Override
    protected MonthDay parseDefault(String jsonValue, Locale locale) {
        return MonthDay.parse(jsonValue, DEFAULT_FORMAT.withLocale(locale));
    }

    @Override
    protected MonthDay parseWithFormatter(String jsonValue, DateTimeFormatter formatter) {
        return MonthDay.parse(jsonValue, formatter);
    }
}

