/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.config;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Errors;
import io.helidon.common.Generated;
import io.helidon.config.ConfigItemBlueprint;
import java.util.Objects;
import java.util.Optional;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.config.ConfigItemBlueprint")
public interface ConfigItem
extends ConfigItemBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(ConfigItem instance) {
        return (Builder)ConfigItem.builder().from(instance);
    }

    public static ConfigItem create() {
        return ConfigItem.builder().buildPrototype();
    }

    public static class Builder
    extends BuilderBase<Builder, ConfigItem>
    implements io.helidon.common.Builder<Builder, ConfigItem> {
        private Builder() {
        }

        public ConfigItem buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.ConfigItemImpl(this);
        }

        public ConfigItem build() {
            return this.buildPrototype();
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends ConfigItem>
    implements Prototype.Builder<BUILDER, PROTOTYPE> {
        private boolean cacheItem;
        private String item;

        protected BuilderBase() {
        }

        public BUILDER from(ConfigItem prototype) {
            this.cacheItem(prototype.cacheItem());
            this.item(prototype.item());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.cacheItem(builder.cacheItem());
            builder.item().ifPresent(this::item);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER cacheItem(boolean cacheItem) {
            this.cacheItem = cacheItem;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER item(String item) {
            Objects.requireNonNull(item);
            this.item = item;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean cacheItem() {
            return this.cacheItem;
        }

        public Optional<String> item() {
            return Optional.ofNullable(this.item);
        }

        public String toString() {
            return "ConfigItemBuilder{cacheItem=" + this.cacheItem + ",item=" + this.item + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
            Errors.Collector collector = Errors.collector();
            if (this.item == null) {
                collector.fatal(this.getClass(), "Property \"item\" must not be null, but not set");
            }
            collector.collect().checkValid();
        }

        protected static class ConfigItemImpl
        implements ConfigItem {
            private final boolean cacheItem;
            private final String item;

            protected ConfigItemImpl(BuilderBase<?, ?> builder) {
                this.cacheItem = builder.cacheItem();
                this.item = builder.item().get();
            }

            @Override
            public boolean cacheItem() {
                return this.cacheItem;
            }

            @Override
            public String item() {
                return this.item;
            }

            public String toString() {
                return "ConfigItem{cacheItem=" + this.cacheItem + ",item=" + this.item + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof ConfigItem)) {
                    return false;
                }
                ConfigItem other = (ConfigItem)o;
                return this.cacheItem == other.cacheItem() && Objects.equals(this.item, other.item());
            }

            public int hashCode() {
                return Objects.hash(this.cacheItem, this.item);
            }
        }
    }
}

