/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application;

import com.sun.faces.config.WebConfiguration;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.Util;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;

public class ApplicationStateInfo {
    private static final Logger LOGGER = FacesLogger.APPLICATION.getLogger();
    private final boolean partialStateSaving;
    private Set<String> fullStateViewIds;

    public ApplicationStateInfo() {
        WebConfiguration config = WebConfiguration.getInstance();
        this.partialStateSaving = config.isOptionEnabled(WebConfiguration.BooleanWebContextInitParameter.PartialStateSaving);
        if (this.partialStateSaving) {
            String[] viewIds = config.getOptionValue(WebConfiguration.WebContextInitParameter.FullStateSavingViewIds, ",");
            this.fullStateViewIds = new HashSet<String>(viewIds.length, 1.0f);
            this.fullStateViewIds.addAll(Arrays.asList(viewIds));
        } else {
            LOGGER.warning("The configuration 'jakarta.faces.PARTIAL_STATE_SAVING' is deprecated as of Faces 4.1 and should not longer be used.");
        }
    }

    public boolean usePartialStateSaving(String viewId) {
        Util.notNullViewId(viewId);
        return this.partialStateSaving && !this.fullStateViewIds.contains(viewId);
    }
}

