/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa;

import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.LockModeType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.persistence.internal.sessions.AbstractSession;

class OptionUtils {
    OptionUtils() {
    }

    static void setCacheRetrieveMode(Map<?, Object> properties, CacheRetrieveMode cacheRetrieveMode) {
        properties.put("jakarta.persistence.cache.retrieveMode", cacheRetrieveMode);
    }

    static CacheRetrieveMode getCacheRetrieveMode(AbstractSession session, Map<?, Object> properties) {
        Object propertyValue = properties.get("jakarta.persistence.cache.retrieveMode");
        if (propertyValue instanceof CacheRetrieveMode) {
            return (CacheRetrieveMode)propertyValue;
        }
        if (propertyValue != null) {
            session.log(6, "query", "unknown_property_type", (Object)propertyValue.getClass().getName(), (Object)"jakarta.persistence.cache.retrieveMode");
        }
        return CacheRetrieveMode.USE;
    }

    static CacheStoreMode getCacheStoreMode(AbstractSession session, Map<?, Object> properties) {
        Object propertyValue = properties.get("jakarta.persistence.cache.storeMode");
        if (propertyValue instanceof CacheStoreMode) {
            return (CacheStoreMode)propertyValue;
        }
        if (propertyValue != null) {
            session.log(6, "query", "unknown_property_type", (Object)propertyValue.getClass().getName(), (Object)"jakarta.persistence.cache.storeMode");
        }
        return CacheStoreMode.USE;
    }

    static void setCacheStoreMode(Map<?, Object> properties, CacheStoreMode cacheStoreMode) {
        properties.put("jakarta.persistence.cache.storeMode", cacheStoreMode);
    }

    static Integer getTimeout(AbstractSession session, Map<?, Object> properties) {
        TimeUnit timeUnit = TimeUnit.MILLISECONDS;
        Object propertyValue = properties.get("eclipselink.query.timeout.unit");
        if (propertyValue instanceof TimeUnit) {
            timeUnit = (TimeUnit)((Object)propertyValue);
        } else if (propertyValue != null) {
            session.log(6, "query", "unknown_property_type", (Object)propertyValue.getClass().getName(), (Object)"eclipselink.query.timeout.unit");
        }
        propertyValue = properties.get("jakarta.persistence.query.timeout");
        if (propertyValue instanceof Number) {
            Number n = (Number)propertyValue;
            return (int)TimeUnit.MILLISECONDS.convert(n.longValue(), timeUnit);
        }
        if (propertyValue instanceof String) {
            String s = (String)propertyValue;
            try {
                long value = Long.parseLong(s);
                return (int)TimeUnit.MILLISECONDS.convert(value, timeUnit);
            }
            catch (NumberFormatException e) {
                session.log(6, "query", "error_queryTimeoutParse", (Object)s, (Object)e.getLocalizedMessage());
            }
        } else {
            session.log(6, "query", "unknown_property_type", (Object)propertyValue.getClass().getName(), (Object)"jakarta.persistence.query.timeout");
        }
        return null;
    }

    static void setTimeout(Map<?, Object> properties, Integer timeout) {
        properties.put("eclipselink.query.timeout.unit", (Object)TimeUnit.MILLISECONDS);
        properties.put("jakarta.persistence.query.timeout", timeout);
    }

    static abstract class OptionsBuilder {
        static final int MAP_CAPACITY = 8;
        private final Map<String, Object> properties;
        private LockModeType lockModeType = null;

        OptionsBuilder(Map<String, Object> properties) {
            if (properties != null) {
                this.properties = new HashMap<String, Object>(properties.size() + 8);
                this.properties.putAll(properties);
            } else {
                this.properties = new HashMap<String, Object>(8);
            }
        }

        void putProperty(String key, Object value) {
            this.properties.put(key, value);
        }

        Map<String, Object> getProperties() {
            return this.properties;
        }

        LockModeType getLockModeType() {
            return this.lockModeType;
        }

        void setLockModeType(LockModeType lockModeType) {
            this.lockModeType = lockModeType;
        }
    }

    record Options(LockModeType lockModeType, Map<String, Object> properties) {
    }
}

