/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers.interceptors;

import com.sun.ejb.containers.interceptors.CallbackInterceptor;
import com.sun.ejb.containers.interceptors.CallbackInvocationContext;
import java.lang.reflect.Method;

class CallbackChainImpl {
    protected CallbackInterceptor[] interceptors;
    protected int size;
    private Method method = null;

    CallbackChainImpl(CallbackInterceptor[] interceptors) {
        this.interceptors = interceptors;
        int n = this.size = interceptors == null ? 0 : interceptors.length;
        if (this.size > 0 && interceptors[this.size - 1].isBeanCallback()) {
            this.method = interceptors[this.size - 1].method;
        }
    }

    public Object invokeNext(int index, CallbackInvocationContext invContext) throws Throwable {
        invContext.method = this.method;
        Object result = null;
        if (index < this.size) {
            result = this.interceptors[index].intercept(invContext);
        } else {
            invContext.invokeSpecial();
        }
        return result;
    }

    public String toString() {
        StringBuilder bldr = new StringBuilder("CallbackInterceptorChainImpl");
        for (CallbackInterceptor inter : this.interceptors) {
            bldr.append("\n\t\t").append(inter);
        }
        return bldr.toString();
    }

    public void prependInterceptor(CallbackInterceptor interceptor) {
        ++this.size;
        CallbackInterceptor[] newArray = new CallbackInterceptor[this.size];
        newArray[0] = interceptor;
        for (int i = 1; i < this.size; ++i) {
            newArray[i] = this.interceptors[i - 1];
        }
        this.interceptors = newArray;
    }
}

