/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.cluster.ssh.launcher;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Logger;

public class JavaSystemJschLogger
implements Logger {
    private final System.Logger logger;

    public JavaSystemJschLogger() {
        this.logger = System.getLogger(JSch.class.getName());
    }

    public JavaSystemJschLogger(String loggerName) {
        this.logger = System.getLogger(loggerName);
    }

    @Override
    public boolean isEnabled(int jschLevel) {
        return this.logger.isLoggable(JavaSystemJschLogger.getSystemLoggerLevel(jschLevel));
    }

    @Override
    public void log(int jschLevel, String message) {
        this.logger.log(JavaSystemJschLogger.getSystemLoggerLevel(jschLevel), message);
    }

    @Override
    public void log(int jschLevel, String message, Throwable cause) {
        if (cause != null) {
            this.logger.log(JavaSystemJschLogger.getSystemLoggerLevel(jschLevel), message, cause);
        } else {
            this.logger.log(JavaSystemJschLogger.getSystemLoggerLevel(jschLevel), message);
        }
    }

    static System.Logger.Level getSystemLoggerLevel(int jschLevel) {
        switch (jschLevel) {
            case 0: {
                return System.Logger.Level.TRACE;
            }
            case 1: {
                return System.Logger.Level.DEBUG;
            }
            case 2: {
                return System.Logger.Level.INFO;
            }
            case 3: {
                return System.Logger.Level.WARNING;
            }
            case 4: {
                return System.Logger.Level.ERROR;
            }
        }
        return System.Logger.Level.TRACE;
    }
}

