/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.common;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.common.ActionReporter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.glassfish.api.ActionReport;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="hk2-agent")
@PerLookup
public class PropsFileActionReporter
extends ActionReporter {
    private boolean useMainChildrenAttr;
    private final Set<String> fixedNames = new TreeSet<String>();
    private static final int LONGEST = 62;

    @Override
    public void setMessage(String message) {
        super.setMessage(PropsFileActionReporter.encodeEOL(message));
    }

    public void writeReport(OutputStream os) throws IOException {
        Manifest out = new Manifest();
        Attributes mainAttr = out.getMainAttributes();
        mainAttr.put(Attributes.Name.SIGNATURE_VERSION, "1.0");
        mainAttr.putValue("exit-code", this.exitCode.toString());
        mainAttr.putValue("use-main-children-attribute", Boolean.toString(this.useMainChildrenAttr));
        if (this.exitCode == ActionReport.ExitCode.FAILURE) {
            this.writeCause(mainAttr);
        }
        this.writeReport(null, this.topMessage, out, mainAttr);
        out.write(os);
    }

    public void writeReport(String prefix, ActionReport.MessagePart part, Manifest m, Attributes attr) {
        CharSequence keys;
        StringBuilder sb = new StringBuilder();
        this.getCombinedMessages(this, sb);
        attr.putValue("message", sb.toString());
        if (!part.getProps().isEmpty()) {
            keys = null;
            for (Map.Entry<Object, Object> entry : part.getProps().entrySet()) {
                String key = this.fixKey(entry.getKey().toString());
                keys = keys == null ? key : (String)keys + ";" + key;
                attr.putValue(key + "_name", entry.getKey().toString());
                attr.putValue(key + "_value", PropsFileActionReporter.encodeEOL(entry.getValue().toString()));
            }
            attr.putValue("keys", (String)keys);
        }
        if (!part.getChildren().isEmpty()) {
            attr.putValue("children-type", part.getChildrenType());
            attr.putValue("use-main-children-attribute", "true");
            keys = null;
            for (ActionReport.MessagePart child : part.getChildren()) {
                String newPrefix;
                String cm = child.getMessage();
                if (cm != null) {
                    cm = URLEncoder.encode(cm, StandardCharsets.UTF_8);
                }
                String string = newPrefix = prefix == null ? cm : prefix + "." + cm;
                if (keys == null) {
                    keys = new StringBuilder();
                } else {
                    ((StringBuilder)keys).append(';');
                }
                if (newPrefix != null) {
                    ((StringBuilder)keys).append(newPrefix);
                }
                Attributes childAttr = new Attributes();
                m.getEntries().put(newPrefix, childAttr);
                this.writeReport(newPrefix, child, m, childAttr);
            }
            attr.putValue("children", ((StringBuilder)keys).toString());
        }
    }

    private void writeCause(Attributes mainAttr) {
        Throwable t = this.getFailureCause();
        if (t == null) {
            return;
        }
        String causeMessage = t.toString();
        mainAttr.putValue("cause", causeMessage);
    }

    public void useMainChildrenAttribute(boolean useMainChildrenAttr) {
        this.useMainChildrenAttr = useMainChildrenAttr;
    }

    private String fixKey(String key) {
        if (!StringUtils.ok((String)key)) {
            return key;
        }
        StringBuilder sb = new StringBuilder();
        boolean wasChanged = false;
        int len = key.length();
        if (len > 62) {
            len = 62;
            wasChanged = true;
        }
        for (int i = 0; i < len; ++i) {
            char c = key.charAt(i);
            if (!PropsFileActionReporter.isValid(c)) {
                wasChanged = true;
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        if (!wasChanged) {
            return key;
        }
        String fixedName = sb.toString();
        if (this.fixedNames.add(fixedName)) {
            return fixedName;
        }
        return this.doubleFixName(fixedName);
    }

    private String doubleFixName(String s) {
        int len = s.length();
        if (len > 57) {
            s = s.substring(0, 57);
        }
        for (int i = 0; i < 10000; ++i) {
            String num = String.format("%05d", i);
            String ret = s + num;
            if (!this.fixedNames.add(ret)) continue;
            return ret;
        }
        throw new IllegalArgumentException("Could not come up with a unique name after 10000 attempts!!");
    }

    private static boolean isValid(char c) {
        return PropsFileActionReporter.isAlpha(c) || PropsFileActionReporter.isDigit(c) || c == '_' || c == '-';
    }

    private static boolean isAlpha(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static String encodeEOL(String m) {
        if (m != null) {
            m = m.replace("\n", "%%%EOL%%%").replace(System.getProperty("line.separator"), "%%%EOL%%%");
        }
        return m;
    }
}

