/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.se.context.activation.interceptor;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.context.Destroyed;
import jakarta.enterprise.context.Initialized;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.event.Observes;
import java.util.concurrent.atomic.AtomicInteger;

@ApplicationScoped
public class RequestContextObserver {
    private final AtomicInteger initCounter = new AtomicInteger(0);
    private final AtomicInteger beforeDestroyedCounter = new AtomicInteger(0);
    private final AtomicInteger destroyedCounter = new AtomicInteger(0);

    public void observesRequestContextInitialization(@Observes @Initialized(value=RequestScoped.class) Object object) {
        this.initCounter.incrementAndGet();
    }

    public void observesRequestContextBeforeDestroyed(@Observes @BeforeDestroyed(value=RequestScoped.class) Object object) {
        this.beforeDestroyedCounter.incrementAndGet();
    }

    public void observesRequestContextDestroyed(@Observes @Destroyed(value=RequestScoped.class) Object object) {
        this.destroyedCounter.incrementAndGet();
    }

    public int getInitCounter() {
        return this.initCounter.get();
    }

    public int getBeforeDestroyedCounter() {
        return this.beforeDestroyedCounter.get();
    }

    public int getDestroyedCounter() {
        return this.destroyedCounter.get();
    }
}

