/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable;

import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.UnproxyableResolutionException;
import jakarta.enterprise.inject.spi.Bean;
import java.lang.annotation.Annotation;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable.UnproxyableBean;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable.UnproxyableBeanWithPackagePrivateFinalMethod;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable.UnproxyableBeanWithProtectedFinalMethod;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable.UnproxyableBeanWithPublicFinalMethod;
import org.jboss.cdi.tck.tests.implementation.simple.lifecycle.unproxyable.UnproxyableFinalClass;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class UnproxyableManagedBeanTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(UnproxyableManagedBeanTest.class)).build();
    }

    @Test(expectedExceptions={UnproxyableResolutionException.class})
    @SpecAssertion(section="contextual_reference", id="a")
    public void testNormalScopedUnproxyableBeanWithPrivateConstructorResolution() {
        this.testObtainingContextualReference(UnproxyableBean.class);
    }

    @Test(expectedExceptions={UnproxyableResolutionException.class})
    @SpecAssertion(section="contextual_reference", id="a")
    public void testNormalScopedUnproxyableBeanWithFinalClassResolution() {
        this.testObtainingContextualReference(UnproxyableFinalClass.class);
    }

    @Test(expectedExceptions={UnproxyableResolutionException.class})
    @SpecAssertion(section="contextual_reference", id="a")
    public void testNormalScopedUnproxyableBeanWithPublicFinalMethodResolution() {
        this.testObtainingContextualReference(UnproxyableBeanWithPublicFinalMethod.class);
    }

    @Test(expectedExceptions={UnproxyableResolutionException.class})
    @SpecAssertion(section="contextual_reference", id="a")
    public void testNormalScopedUnproxyableBeanWithProtectedFinalMethodResolution() {
        this.testObtainingContextualReference(UnproxyableBeanWithProtectedFinalMethod.class);
    }

    @Test(expectedExceptions={UnproxyableResolutionException.class})
    @SpecAssertion(section="contextual_reference", id="a")
    public void testNormalScopedUnproxyableBeanWithPackagePrivateFinalMethodResolution() {
        this.testObtainingContextualReference(UnproxyableBeanWithPackagePrivateFinalMethod.class);
    }

    private <T> void testObtainingContextualReference(Class<T> t) {
        Bean<T> bean = this.getUniqueBean(t, new Annotation[0]);
        CreationalContext ctx = this.getCurrentManager().createCreationalContext(bean);
        this.getCurrentManager().getReference(bean, t, ctx);
    }
}

