/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.full.extensions.beanManager;

import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.InjectionException;
import jakarta.enterprise.inject.Specializes;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.interceptor.InterceptorBinding;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Set;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.literals.InheritedLiteral;
import org.jboss.cdi.tck.literals.RetentionLiteral;
import org.jboss.cdi.tck.literals.StereotypeLiteral;
import org.jboss.cdi.tck.literals.TargetLiteral;
import org.jboss.cdi.tck.shrinkwrap.WebArchiveBuilder;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.AfterBeanDiscoveryObserver;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.AnimalStereotype;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.DerivedBean;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.DogHouse;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.DummyScoped;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.InjectionPointDecorator;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.Snake;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.Tame;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.Transactional;
import org.jboss.cdi.tck.tests.full.extensions.beanManager.UnregisteredExtension;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"cdi-full"})
@SpecVersion(spec="cdi", version="2.0")
public class BeanManagerTest
extends AbstractTest {
    @Deployment
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)((WebArchiveBuilder)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(BeanManagerTest.class)).withClasses(RetentionLiteral.class, TargetLiteral.class, StereotypeLiteral.class, InheritedLiteral.class)).withExtensions(AfterBeanDiscoveryObserver.class)).build();
    }

    @Test(expectedExceptions={InjectionException.class})
    @SpecAssertion(section="bm_validate_ip", id="a")
    public void testValidateThrowsException() {
        DogHouse dogHouse = this.getContextualReference(DogHouse.class, new Annotation[0]);
        InjectionPointDecorator injectionPoint = new InjectionPointDecorator(dogHouse.getDog().getInjectedMetadata());
        this.getCurrentManager().validate((InjectionPoint)injectionPoint);
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ae")
    public void testGetMetaAnnotationsForStereotype() {
        Set stereotypeAnnotations = this.getCurrentManager().getStereotypeDefinition(AnimalStereotype.class);
        Assert.assertEquals((int)stereotypeAnnotations.size(), (int)5);
        Assert.assertTrue((boolean)stereotypeAnnotations.contains((Object)StereotypeLiteral.INSTANCE));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(RequestScoped.Literal.INSTANCE));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(InheritedLiteral.INSTANCE));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new RetentionLiteral(){

            @Override
            public RetentionPolicy value() {
                return RetentionPolicy.RUNTIME;
            }
        }));
        Assert.assertTrue((boolean)stereotypeAnnotations.contains(new TargetLiteral(){

            @Override
            public ElementType[] value() {
                ElementType[] value = new ElementType[]{ElementType.TYPE, ElementType.METHOD, ElementType.FIELD};
                return value;
            }
        }));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="af")
    public void testGetMetaAnnotationsForInterceptorBindingType() {
        Set metaAnnotations = this.getCurrentManager().getInterceptorBindingDefinition(Transactional.class);
        Assert.assertEquals((int)metaAnnotations.size(), (int)4);
        assert (this.annotationSetMatches((Set<? extends Annotation>)metaAnnotations, Target.class, Retention.class, Documented.class, InterceptorBinding.class));
    }

    @Test
    @SpecAssertion(section="bm_determining_annotation", id="ag")
    public void testDetermineScopeType() {
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(RequestScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isPassivatingScope(RequestScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(SessionScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isPassivatingScope(SessionScoped.class));
        Assert.assertTrue((boolean)this.getCurrentManager().isNormalScope(DummyScoped.class));
        Assert.assertFalse((boolean)this.getCurrentManager().isPassivatingScope(DummyScoped.class));
    }

    @Test
    @SpecAssertion(section="bm_obtain_elresolver", id="a")
    public void testGetELResolver() {
        Assert.assertNotNull((Object)this.getCurrentManager().getELResolver());
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_annotatedtype", id="a")})
    public void testObtainingAnnotatedType() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Specializes.class));
        Assert.assertTrue((boolean)annotatedType.isAnnotationPresent(Tame.class));
        Assert.assertEquals((int)1, (int)annotatedType.getFields().size());
        Assert.assertTrue((boolean)annotatedType.getMethods().isEmpty());
        Assert.assertEquals((int)3, (int)annotatedType.getTypeClosure().size());
    }

    @Test
    @SpecAssertion(section="bm_obtain_injectiontarget", id="aa")
    public void testObtainingInjectionTarget() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(DerivedBean.class);
        Assert.assertNotNull((Object)this.getCurrentManager().getInjectionTargetFactory(annotatedType).createInjectionTarget(null));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    @SpecAssertion(section="bm_obtain_injectiontarget", id="ab")
    public void testObtainingInjectionTargetWithDefinitionError() {
        AnnotatedType annotatedType = this.getCurrentManager().createAnnotatedType(Snake.class);
        this.getCurrentManager().getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="bm_obtain_extension", id="a"), @SpecAssertion(section="bm_obtain_extension", id="b")})
    public void testGetExtension() {
        AfterBeanDiscoveryObserver extension = (AfterBeanDiscoveryObserver)this.getCurrentManager().getExtension(AfterBeanDiscoveryObserver.class);
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((boolean)extension.getAfterBeanDiscoveryObserved());
        try {
            this.getCurrentManager().getExtension(UnregisteredExtension.class);
        }
        catch (Throwable t) {
            Assert.assertTrue((boolean)this.isThrowablePresent(IllegalArgumentException.class, t));
            return;
        }
        Assert.fail();
    }

    @Test
    @SpecAssertion(section="beanmanager", id="b")
    public void testManagerBeanIsPassivationCapable() {
        Assert.assertTrue((boolean)this.isSerializable(this.getCurrentManager().getClass()));
    }

    private boolean isSerializable(Class<?> clazz) {
        return clazz.isPrimitive() || Serializable.class.isAssignableFrom(clazz);
    }
}

