/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class SessionContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(SessionContextAsyncListenerTest.class)).build();
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="ad")})
    public void testSessionContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("complete"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
        String id = this.extractSimpleSessionBeanId(results.getContent());
        Assert.assertNotNull((Object)id);
        Assert.assertFalse((boolean)id.isEmpty());
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="ad")})
    public void testSessionContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("timeout"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onTimeout: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="ad")})
    public void testSessionContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("error"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onError: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="session_context_ee", id="ad")})
    public void testSessionContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("loop"));
        TextPage results = (TextPage)webClient.getPage(this.contextPath + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
        Assert.assertTrue((boolean)results.getContent().contains("onStartAsync: true"));
    }

    private String getPath(String test) {
        return this.contextPath + "AsyncServlet?test=" + test;
    }

    private String extractSimpleSessionBeanId(String content) {
        Matcher matcher = Pattern.compile("^(.+)(simpleSessionBeanId: )(.+)$").matcher(content);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }
}

