/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.session.listener.shutdown;

import jakarta.enterprise.context.SessionScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.inject.Inject;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import org.jboss.cdi.tck.tests.context.session.listener.shutdown.SessionScopedTestFlagClient;
import org.jboss.cdi.tck.util.SimpleLogger;

@WebListener
public class TestHttpSessionListener
implements HttpSessionListener {
    private static final SimpleLogger logger = new SimpleLogger(TestHttpSessionListener.class);
    @Inject
    BeanManager beanManager;
    @Inject
    SessionScopedTestFlagClient client;

    public void sessionCreated(HttpSessionEvent se) {
        logger.log("Session {0} created...", new Object[]{se.getSession().getId()});
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        logger.log("Session {0} destroyed...", new Object[]{se.getSession().getId()});
        this.checkSessionContextActive();
    }

    private void checkSessionContextActive() throws IllegalStateException {
        try {
            if (!this.beanManager.getContext(SessionScoped.class).isActive() || this.client == null) {
                return;
            }
            this.client.setTestFlag();
        }
        catch (Exception e) {
            logger.log("Unable to set test flag: {0}", new Object[]{e.getMessage()});
        }
    }
}

