/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.conversation;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.Conversation;
import jakarta.enterprise.context.ConversationScoped;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.faces.event.PhaseEvent;
import jakarta.faces.event.PhaseId;
import jakarta.faces.event.PhaseListener;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.annotation.Annotation;
import org.jboss.cdi.tck.tests.context.conversation.Cloud;
import org.jboss.cdi.tck.util.BeanLookupUtils;

public class ConversationTestPhaseListener
implements PhaseListener {
    private static final long serialVersionUID = 1197355854770726526L;
    public static final String ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME = "org.jboss.cdi.tck.activeBeforeApplyRequestValues";
    private boolean activeBeforeApplyRequestValues;

    public void afterPhase(PhaseEvent event) {
    }

    public void beforePhase(PhaseEvent event) {
        BeanManager beanManager = CDI.current().getBeanManager();
        if (event.getPhaseId().equals(PhaseId.APPLY_REQUEST_VALUES)) {
            try {
                beanManager.getContext(ConversationScoped.class);
                this.activeBeforeApplyRequestValues = true;
            }
            catch (ContextNotActiveException e) {
                this.activeBeforeApplyRequestValues = false;
            }
        }
        if (event.getPhaseId().equals(PhaseId.RENDER_RESPONSE)) {
            Conversation conversation = (Conversation)CDI.current().select(Conversation.class, new Annotation[0]).get();
            HttpServletResponse response = (HttpServletResponse)event.getFacesContext().getExternalContext().getResponse();
            response.addHeader("org.jboss.cdi.tck.cid", conversation.getId() == null ? " null" : conversation.getId());
            response.addHeader("org.jboss.cdi.tck.longRunning", String.valueOf(!conversation.isTransient()));
            response.addHeader(Cloud.RAINED_HEADER_NAME, new Boolean(((Cloud)BeanLookupUtils.getContextualReference((BeanManager)beanManager, Cloud.class, (Annotation[])new Annotation[0])).isRained()).toString());
            response.addHeader(ACTIVE_BEFORE_APPLY_REQUEST_VALUES_HEADER_NAME, new Boolean(this.activeBeforeApplyRequestValues).toString());
        }
    }

    public PhaseId getPhaseId() {
        return PhaseId.ANY_PHASE;
    }
}

