/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.internal.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecp.core.ECPProjectManager;
import org.eclipse.emf.ecp.core.ECPProviderRegistry;
import org.eclipse.emf.ecp.core.ECPRepositoryManager;
import org.eclipse.emf.ecp.core.util.observer.ECPObserverBus;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.emf.ecp.core";
    private static Activator instance;

    public void start(BundleContext bundleContext) throws Exception {
        instance = this;
        super.start(bundleContext);
    }

    public void stop(BundleContext bundleContext) throws Exception {
        instance = null;
        super.stop(bundleContext);
    }

    public static Activator getInstance() {
        return instance;
    }

    public static void log(String message) {
        instance.getLog().log((IStatus)new Status(1, PLUGIN_ID, message));
    }

    public static void log(int status, String message) {
        instance.getLog().log((IStatus)new Status(status, PLUGIN_ID, message));
    }

    private static void log(IStatus status) {
        instance.getLog().log(status);
    }

    public static String log(Throwable t) {
        IStatus status = Activator.getStatus(t);
        Activator.log(status);
        return status.getMessage();
    }

    private static IStatus getStatus(Throwable t) {
        if (t instanceof CoreException) {
            CoreException coreException = (CoreException)t;
            return coreException.getStatus();
        }
        String msg = t.getLocalizedMessage();
        if (msg == null || msg.length() == 0) {
            msg = t.getClass().getName();
        }
        return new Status(4, PLUGIN_ID, msg, t);
    }

    public static synchronized ECPProjectManager getECPProjectManager() {
        ECPProjectManager ecpProjectManager = null;
        ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPProjectManager.class);
        ecpProjectManager = (ECPProjectManager)instance.getBundle().getBundleContext().getService(serviceRef);
        instance.getBundle().getBundleContext().ungetService(serviceRef);
        return ecpProjectManager;
    }

    public static synchronized ECPRepositoryManager getECPRepositoryManager() {
        ECPRepositoryManager ecpRepositoryManager = null;
        ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPRepositoryManager.class);
        ecpRepositoryManager = (ECPRepositoryManager)instance.getBundle().getBundleContext().getService(serviceRef);
        instance.getBundle().getBundleContext().ungetService(serviceRef);
        return ecpRepositoryManager;
    }

    public static synchronized ECPProviderRegistry getECPProviderRegistry() {
        ECPProviderRegistry ecpProviderRegistry = null;
        ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPProviderRegistry.class);
        ecpProviderRegistry = (ECPProviderRegistry)instance.getBundle().getBundleContext().getService(serviceRef);
        instance.getBundle().getBundleContext().ungetService(serviceRef);
        return ecpProviderRegistry;
    }

    public static synchronized ECPObserverBus getECPObserverBus() {
        ECPObserverBus ecpObserverBus = null;
        ServiceReference serviceRef = instance.getBundle().getBundleContext().getServiceReference(ECPObserverBus.class);
        ecpObserverBus = (ECPObserverBus)instance.getBundle().getBundleContext().getService(serviceRef);
        instance.getBundle().getBundleContext().ungetService(serviceRef);
        return ecpObserverBus;
    }
}

